/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineBpmnConfig;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraProcessEngineConfiguration;
import ru.tinkoff.kora.camunda.engine.bpmn.configurator.ProcessEngineConfigurator;
import ru.tinkoff.kora.common.util.TimeUtils;

public final class KoraProcessEngine
implements Lifecycle,
Wrapped<ProcessEngine> {
    private static final Logger logger = LoggerFactory.getLogger(KoraProcessEngine.class);
    private final ProcessEngineConfiguration engineConfiguration;
    private final CamundaEngineBpmnConfig engineConfig;
    private final List<ProcessEngineConfigurator> camundaConfigurators;
    private volatile ProcessEngine processEngine;

    public KoraProcessEngine(ProcessEngineConfiguration engineConfiguration, CamundaEngineBpmnConfig engineConfig, List<ProcessEngineConfigurator> camundaConfigurators) {
        this.engineConfiguration = engineConfiguration;
        this.engineConfig = engineConfig;
        this.camundaConfigurators = camundaConfigurators;
    }

    public void init() {
        if (this.engineConfig.parallelInitialization().enabled() && this.engineConfiguration instanceof KoraProcessEngineConfiguration) {
            logger.info("Camunda BPMN Engine parallel initialization enabled");
            logger.debug("Camunda BPMN Engine starting first stage...");
            long started = TimeUtils.started();
            this.processEngine = this.engineConfiguration.buildProcessEngine();
            ProcessEngines.registerProcessEngine((ProcessEngine)this.processEngine);
            logger.info("Camunda BPMN Engine started first stage in {}", (Object)TimeUtils.tookForLogging((long)started));
        } else {
            logger.debug("Camunda BPMN Engine starting...");
            long started = TimeUtils.started();
            this.processEngine = this.engineConfiguration.buildProcessEngine();
            ProcessEngines.registerProcessEngine((ProcessEngine)this.processEngine);
            logger.info("Camunda BPMN Engine started in {}", (Object)TimeUtils.tookForLogging((long)started));
            logger.debug("Camunda BPMN Engine configuring...");
            long startedConfiguring = TimeUtils.started();
            CompletableFuture[] setups = (CompletableFuture[])this.camundaConfigurators.stream().map(c -> CompletableFuture.runAsync(() -> {
                try {
                    c.setup(this.processEngine);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            })).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(setups).join();
            logger.info("Camunda BPMN Engine configured in {}", (Object)TimeUtils.tookForLogging((long)startedConfiguring));
        }
    }

    public void release() {
        logger.debug("Camunda BPMN Engine stopping...");
        long started = TimeUtils.started();
        ProcessEngines.unregister((ProcessEngine)this.processEngine);
        this.processEngine.close();
        logger.info("Camunda BPMN Engine stopped in {}", (Object)TimeUtils.tookForLogging((long)started));
    }

    public ProcessEngine value() {
        return this.processEngine;
    }
}

