/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn.configurator;

import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineBpmnConfig;
import ru.tinkoff.kora.camunda.engine.bpmn.configurator.ProcessEngineConfigurator;
import ru.tinkoff.kora.common.util.TimeUtils;

public final class DeploymentProcessEngineConfigurator
implements ProcessEngineConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentProcessEngineConfigurator.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final CamundaEngineBpmnConfig engineConfig;

    public DeploymentProcessEngineConfigurator(CamundaEngineBpmnConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    @Override
    public void setup(ProcessEngine engine) {
        try {
            CamundaEngineBpmnConfig.DeploymentConfig deployment = this.engineConfig.deployment();
            if (deployment != null && !deployment.resources().isEmpty()) {
                Set<String> normalizedLocations = deployment.resources().stream().map(location -> {
                    if (location.startsWith("classpath:")) {
                        return location.substring(10);
                    }
                    logger.warn("Only locations with `classpath:` prefix are supported, skipping unsupported resource location: {}", location);
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toSet());
                if (deployment.delay() == null) {
                    this.deployProcessModels(normalizedLocations, deployment, engine.getRepositoryService());
                } else {
                    this.scheduler.schedule(() -> {
                        try {
                            this.deployProcessModels(normalizedLocations, deployment, engine.getRepositoryService());
                        }
                        catch (IOException e) {
                            logger.error("Camunda Configurator deploying {} resources failed", (Object)normalizedLocations, (Object)e);
                        }
                    }, deployment.delay().toMillis(), TimeUnit.MILLISECONDS);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void deployProcessModels(Set<String> normalizedLocations, CamundaEngineBpmnConfig.DeploymentConfig deploymentConfig, RepositoryService repositoryService) throws IOException {
        logger.debug("Camunda Configurator deploying {} resources...", normalizedLocations);
        long started = TimeUtils.started();
        List<Resource> resources = ClasspathResourceUtils.findResources(normalizedLocations);
        if (resources.isEmpty()) {
            logger.debug("Camunda Configurator found 0 resources");
        } else {
            DeploymentBuilder builder = repositoryService.createDeployment().name(deploymentConfig.name()).source(deploymentConfig.name()).enableDuplicateFiltering(deploymentConfig.deployChangedOnly());
            if (deploymentConfig.tenantId() != null) {
                builder = builder.tenantId(deploymentConfig.tenantId());
            }
            Iterator<Resource> iterator = resources.iterator();
            while (iterator.hasNext()) {
                Resource resource;
                Resource res = resource = iterator.next();
                try {
                    builder.addInputStream(res.name(), res.asInputStream());
                }
                finally {
                    if (res == null) continue;
                    res.close();
                }
            }
            Deployment deployment = builder.deploy();
            logger.info("Camunda Configurator deployed {} resources with deployment id '{}' in {}", new Object[]{resources, deployment.getId(), TimeUtils.tookForLogging((long)started)});
        }
    }

    static final class ClasspathResourceUtils {
        private ClasspathResourceUtils() {
        }

        public static Optional<Resource> findResource(String path) {
            return ClasspathResourceUtils.findResources(path).stream().findFirst();
        }

        public static List<Resource> findResources(Collection<String> paths) {
            return paths.stream().distinct().flatMap(p -> ClasspathResourceUtils.findResources(p).stream()).distinct().toList();
        }

        public static List<Resource> findResources(String path) {
            Pattern pattern;
            List<URL> pathResources;
            String workPath;
            if (path == null || path.isBlank()) {
                return Collections.emptyList();
            }
            if (path.startsWith("./")) {
                return ClasspathResourceUtils.findResources(path.substring(2));
            }
            if (path.startsWith("/")) {
                return ClasspathResourceUtils.findResources(path.substring(1));
            }
            int innerDirectoryFrom = path.lastIndexOf(47);
            if (innerDirectoryFrom == -1) {
                List<URL> directoryOnlyResources = ClasspathResourceUtils.getSystemResources(path);
                if (!directoryOnlyResources.isEmpty()) {
                    workPath = path;
                    pathResources = directoryOnlyResources;
                    pattern = null;
                } else {
                    workPath = ".";
                    pathResources = ClasspathResourceUtils.getSystemResources(workPath);
                    pattern = Pattern.compile("^" + path);
                }
            } else {
                workPath = path.substring(0, innerDirectoryFrom);
                pathResources = ClasspathResourceUtils.getSystemResources(workPath);
                pattern = Pattern.compile("^" + path.substring(innerDirectoryFrom + 1));
            }
            return pathResources.stream().map(r -> {
                if (r.toString().startsWith("jar")) {
                    return ClasspathResourceUtils.loadFromJar(workPath, r, pattern);
                }
                return ClasspathResourceUtils.loadFromDirectory(workPath, r, pattern);
            }).flatMap(Collection::stream).toList();
        }

        private static List<Resource> loadFromDirectory(String path, URL resource, @Nullable Pattern pattern) {
            File filePath = new File(resource.getPath());
            if (filePath.isFile()) {
                if (pattern == null) {
                    return List.of(new FileResource(filePath.getName(), "."));
                }
                if (pattern.matcher(filePath.getName()).matches()) {
                    return List.of(new FileResource(filePath.getName(), path));
                }
                return List.of();
            }
            ArrayList<Resource> resources = new ArrayList<Resource>();
            String[] files = filePath.list();
            if (files == null || files.length == 0) {
                return Collections.emptyList();
            }
            for (String fileName : files) {
                File file = new File(filePath, fileName);
                if (!file.isFile()) continue;
                if (pattern == null) {
                    resources.add(new FileResource(file.getName(), path));
                    continue;
                }
                if (!pattern.matcher(fileName).matches()) continue;
                resources.add(new FileResource(file.getName(), path));
            }
            return resources;
        }

        private static List<Resource> loadFromJar(String path, URL resource, @Nullable Pattern pattern) {
            String jarPath = resource.getPath().replaceFirst("[.]jar!.*", ".jar").replaceFirst("[.]tar!.*", ".tar").replaceFirst("file:", "");
            try {
                String jarUrlPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8);
                logger.info("JarPath {}, path {}, pattern {}", new Object[]{jarPath, path, pattern});
                JarFile jar = new JarFile(jarUrlPath);
                ArrayList<Resource> classes = new ArrayList<Resource>();
                Enumeration<JarEntry> files = jar.entries();
                AtomicInteger closeCounter = new AtomicInteger(0);
                while (files.hasMoreElements()) {
                    JarEntry file = files.nextElement();
                    if (file.isDirectory()) continue;
                    String fileFullName = file.getName();
                    String fileName = fileFullName.lastIndexOf(47) == -1 ? fileFullName : fileFullName.substring(fileFullName.lastIndexOf(47) + 1);
                    logger.info("File {}, path {}, pattern {}", new Object[]{fileFullName, path, pattern});
                    if ((pattern != null || !fileFullName.startsWith(path)) && (pattern == null || !pattern.matcher(fileName).matches())) continue;
                    logger.info("Match pattern {}, fileName {}", (Object)pattern, (Object)fileName);
                    closeCounter.incrementAndGet();
                    classes.add(new JarResource(fileFullName, jarUrlPath, () -> {
                        try {
                            return jar.getInputStream(file);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e.getMessage() + " for file: " + jarPath, e);
                        }
                    }, () -> {
                        int res = closeCounter.decrementAndGet();
                        if (res < 1) {
                            jar.close();
                        }
                    }));
                }
                return classes;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't open Jar '" + jarPath, e);
            }
        }

        private static List<URL> getSystemResources(String path) {
            try {
                Enumeration<URL> resourceUrls = ClasspathResourceUtils.class.getClassLoader().getResources(path);
                if (!resourceUrls.hasMoreElements()) {
                    return Collections.emptyList();
                }
                ArrayList<URL> resources = new ArrayList<URL>();
                while (resourceUrls.hasMoreElements()) {
                    URL url = resourceUrls.nextElement();
                    resources.add(url);
                }
                return resources;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    static interface Resource
    extends Closeable {
        public String name();

        public String path();

        public InputStream asInputStream();
    }

    record FileResource(String name, String path) implements Resource
    {
        @Override
        public InputStream asInputStream() {
            return FileResource.class.getResourceAsStream("/" + this.path + "/" + this.name);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Resource)) {
                return false;
            }
            Resource that = (Resource)object;
            return Objects.equals(this.name, that.name()) && Objects.equals(this.path, that.path());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.path);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    record JarResource(String name, String path, Supplier<InputStream> inputStream, @Nullable Closeable closeable) implements Resource
    {
        public JarResource(String name, String path, Supplier<InputStream> inputStream) {
            this(name, path, inputStream, null);
        }

        @Override
        public InputStream asInputStream() {
            return this.inputStream.get();
        }

        @Override
        public void close() throws IOException {
            if (this.closeable != null) {
                this.closeable.close();
            }
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Resource)) {
                return false;
            }
            Resource that = (Resource)object;
            return Objects.equals(this.name, that.name()) && Objects.equals(this.path, that.path());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.path);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

