/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineBpmnConfig;

public final class KoraJobExecutor
extends DefaultJobExecutor {
    private final CamundaEngineBpmnConfig engineConfig;

    public KoraJobExecutor(CamundaEngineBpmnConfig engineConfig) {
        this.engineConfig = engineConfig;
        CamundaEngineBpmnConfig.JobExecutorConfig jobExecutorConfig = engineConfig.jobExecutor();
        this.setQueueSize(jobExecutorConfig.queueSize());
        this.setCorePoolSize(jobExecutorConfig.corePoolSize());
        this.setMaxPoolSize(jobExecutorConfig.maxPoolSize());
        this.setMaxJobsPerAcquisition(jobExecutorConfig.maxJobsPerAcquisition());
    }

    protected void startExecutingJobs() {
        if (this.threadPoolExecutor == null || this.threadPoolExecutor.isShutdown()) {
            ArrayBlockingQueue<Runnable> threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
            AtomicInteger threadNumber = new AtomicInteger(1);
            this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 0L, TimeUnit.MILLISECONDS, threadPoolQueue, r -> {
                String name = "camunda-worker-" + threadNumber.incrementAndGet();
                Thread t = new Thread(r, name);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            });
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        }
        super.startExecutingJobs();
    }

    public synchronized void registerProcessEngine(ProcessEngineImpl processEngine) {
        if (this.engineConfig.parallelInitialization().enabled()) {
            this.processEngines.add(processEngine);
        } else {
            super.registerProcessEngine(processEngine);
        }
    }
}

