/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineBpmnConfig;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraProcessEngineConfiguration;
import ru.tinkoff.kora.camunda.engine.bpmn.configurator.ProcessEngineConfigurator;
import ru.tinkoff.kora.common.util.TimeUtils;

public final class KoraProcessEngineParallelInitializer
implements Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(KoraProcessEngineParallelInitializer.class);
    private final ProcessEngine processEngine;
    private final CamundaEngineBpmnConfig camundaEngineConfig;
    private final ProcessEngineConfiguration engineConfiguration;
    private final List<ProcessEngineConfigurator> camundaConfigurators;

    public KoraProcessEngineParallelInitializer(ProcessEngine processEngine, CamundaEngineBpmnConfig camundaEngineConfig, ProcessEngineConfiguration engineConfiguration, List<ProcessEngineConfigurator> camundaConfigurators) {
        this.processEngine = processEngine;
        this.camundaEngineConfig = camundaEngineConfig;
        this.engineConfiguration = engineConfiguration;
        this.camundaConfigurators = camundaConfigurators;
    }

    public void init() {
        if (this.camundaEngineConfig.parallelInitialization().enabled() && this.engineConfiguration instanceof KoraProcessEngineConfiguration) {
            logger.debug("Camunda BPMN Engine parallel configuring...");
            long started = TimeUtils.started();
            CompletableFuture[] setups = (CompletableFuture[])this.camundaConfigurators.stream().map(c -> CompletableFuture.runAsync(() -> {
                try {
                    c.setup(this.processEngine);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            })).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(setups).join();
            logger.info("Camunda BPMN Engine parallel configured in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public void release() {
    }
}

