/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn;

import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.session.Configuration;
import org.camunda.bpm.engine.ArtifactFactory;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatistics;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatisticsQuery;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstanceQuery;
import org.camunda.bpm.engine.impl.CleanableHistoricCaseInstanceReportImpl;
import org.camunda.bpm.engine.impl.HistoricCaseActivityInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricCaseActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.HistoricCaseInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoryServiceImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cmmn.CaseServiceImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionQueryImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseInstanceQueryImpl;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.el.JuelExpressionManager;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContextInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CommandCounterInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.LogInterceptor;
import org.camunda.bpm.engine.impl.interceptor.ProcessApplicationContextInterceptor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineBpmnConfig;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineDataSource;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaVersion;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraResolverFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnMetricsFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.transaction.KoraTransactionContextFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.transaction.KoraTransactionInterceptor;

public class KoraProcessEngineConfiguration
extends ProcessEngineConfigurationImpl {
    private static final Logger logger = LoggerFactory.getLogger(KoraProcessEngineConfiguration.class);
    private final JobExecutor jobExecutor;
    private final TelemetryRegistry telemetryRegistry;
    private final KoraResolverFactory componentResolverFactory;
    private final CamundaEngineDataSource camundaEngineDataSource;
    private final CamundaVersion camundaVersion;
    private final CamundaEngineBpmnConfig engineConfig;
    private final List<ProcessEnginePlugin> plugins;
    @Nullable
    private final CamundaEngineBpmnMetricsFactory metricsFactory;

    public KoraProcessEngineConfiguration(JobExecutor jobExecutor, TelemetryRegistry telemetryRegistry, IdGenerator idGenerator, JuelExpressionManager koraExpressionManager, ArtifactFactory artifactFactory, List<ProcessEnginePlugin> plugins, CamundaEngineDataSource camundaEngineDataSource, CamundaEngineBpmnConfig engineConfig, KoraResolverFactory componentResolverFactory, CamundaVersion camundaVersion, @Nullable CamundaEngineBpmnMetricsFactory metricsFactory) {
        this.jobExecutor = jobExecutor;
        this.telemetryRegistry = telemetryRegistry;
        this.componentResolverFactory = componentResolverFactory;
        this.idGenerator = idGenerator;
        this.artifactFactory = artifactFactory;
        this.plugins = plugins;
        this.engineConfig = engineConfig;
        this.camundaEngineDataSource = camundaEngineDataSource;
        this.camundaVersion = camundaVersion;
        this.metricsFactory = metricsFactory;
        this.setDefaultCharset(StandardCharsets.UTF_8);
        this.setDataSource(camundaEngineDataSource.dataSource());
        this.setTransactionsExternallyManaged(true);
        this.setIdGenerator(idGenerator);
        this.setExpressionManager((ExpressionManager)koraExpressionManager);
        this.setArtifactFactory(artifactFactory);
        this.configureDefaultValues();
        this.configureMetricsAndTelemetry();
        this.registerProcessEnginePlugins();
        this.mockUnsupportedCmmnMethods();
    }

    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new KoraTransactionContextFactory(this.camundaEngineDataSource.transactionManager());
        }
    }

    protected void initJobExecutor() {
        this.setJobExecutor(this.jobExecutor);
        super.initJobExecutor();
    }

    protected void initScripting() {
        super.initScripting();
        this.getResolverFactories().add(this.componentResolverFactory);
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired() {
        return this.getCommandInterceptors(false);
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew() {
        return this.getCommandInterceptors(true);
    }

    protected List<CommandInterceptor> getCommandInterceptors(boolean requiresNew) {
        return Arrays.asList(new CommandInterceptor[]{new LogInterceptor(), new CommandCounterInterceptor((ProcessEngineConfigurationImpl)this), new ProcessApplicationContextInterceptor((ProcessEngineConfigurationImpl)this), new KoraTransactionInterceptor(this.camundaEngineDataSource.transactionManager(), requiresNew), new CommandContextInterceptor(this.commandContextFactory, (ProcessEngineConfigurationImpl)this, requiresNew)});
    }

    protected void configureMetricsAndTelemetry() {
        if (this.metricsFactory != null && this.engineConfig.telemetry().engineTelemetryEnabled()) {
            this.setTelemetryRegistry(this.telemetryRegistry);
            this.setMetricsEnabled(true);
            this.setTaskMetricsEnabled(true);
            this.setInitializeTelemetry(true);
            this.setTelemetryReporterActivate(true);
            if (this.camundaVersion.version() == null) {
                logger.warn("Disabling TelemetryReporter because required information 'Camunda Version' is not available.");
                this.setTelemetryReporterActivate(false);
            }
        } else {
            this.setMetricsEnabled(false);
            this.setTaskMetricsEnabled(false);
            this.setInitializeTelemetry(false);
            this.setTelemetryReporterActivate(false);
        }
    }

    protected void configureDefaultValues() {
        this.setJobExecutorActivate(true);
        this.setDatabaseSchemaUpdate("true");
        this.setEnforceHistoryTimeToLive(false);
    }

    protected void registerProcessEnginePlugins() {
        if (!this.plugins.isEmpty()) {
            logger.info("Registering process engine plugins: {}", this.plugins);
            this.setProcessEnginePlugins(this.plugins);
        }
    }

    protected void mockUnsupportedCmmnMethods() {
        this.repositoryService = new RepositoryServiceImpl(){

            public CaseDefinitionQuery createCaseDefinitionQuery() {
                return new CaseDefinitionQueryImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<CaseDefinition> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }
        };
        this.caseService = new CaseServiceImpl(){

            public CaseInstanceQuery createCaseInstanceQuery() {
                return new CaseInstanceQueryImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<CaseInstance> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }

            public CaseExecutionQuery createCaseExecutionQuery() {
                return new CaseExecutionQueryImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<CaseExecution> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }
        };
        this.historyService = new HistoryServiceImpl(){

            public HistoricCaseInstanceQuery createHistoricCaseInstanceQuery() {
                return new HistoricCaseInstanceQueryImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<HistoricCaseInstance> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }

            public HistoricCaseActivityInstanceQuery createHistoricCaseActivityInstanceQuery() {
                return new HistoricCaseActivityInstanceQueryImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<HistoricCaseActivityInstance> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }

            public HistoricCaseActivityStatisticsQuery createHistoricCaseActivityStatisticsQuery(String caseDefinitionId) {
                return new HistoricCaseActivityStatisticsQueryImpl(caseDefinitionId, this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<HistoricCaseActivityStatistics> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }

            public CleanableHistoricCaseInstanceReport createCleanableHistoricCaseInstanceReport() {
                return new CleanableHistoricCaseInstanceReportImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<CleanableHistoricCaseInstanceReportResult> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }
        };
    }

    protected InputStream getMyBatisXmlConfigurationSteam() {
        if (this.engineConfig.parallelInitialization().enabled()) {
            return this.getMyBatisXmlConfigurationSteamStageOne();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(super.getMyBatisXmlConfigurationSteam()));
        try {
            StringBuilder sb = new StringBuilder();
            while (reader.ready()) {
                String line = reader.readLine();
                if (!line.contains("<mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Case")) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                logger.debug("Filtered out CMMN mapping {}", (Object)line);
            }
            return new ByteArrayInputStream(sb.toString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read MyBatis mappings.xml", e);
        }
    }

    protected InputStream getMyBatisXmlConfigurationSteamStageOne() {
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE configuration PUBLIC \"-//mybatis.org//DTD Config 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-config.dtd\">\n\n<configuration>\n\t<settings>\n\t\t<setting name=\"lazyLoadingEnabled\" value=\"false\" />\n\t</settings>\n\t<mappers>\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Commons.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Authorization.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Tenant.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Deployment.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Incident.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Job.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/JobDefinition.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/ProcessDefinition.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Property.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Resource.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Task.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/EventSubscription.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Filter.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/User.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Group.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Membership.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/CamundaFormDefinition.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/DecisionDefinition.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/DecisionRequirementsDefinition.xml\" />" + (this.getHistoryLevel() == HistoryLevel.HISTORY_LEVEL_FULL ? "    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricJobLog.xml\" />\n" : "") + "\n\t</mappers>\n</configuration>\n";
        return new ByteArrayInputStream(s.getBytes());
    }

    public Configuration createConfigurationStageTwo() {
        InputStreamReader reader = new InputStreamReader(this.getMyBatisXmlConfigurationSteamStageTwo());
        Properties properties = new Properties();
        if (this.isUseSharedSqlSessionFactory) {
            properties.put("prefix", "${@org.camunda.bpm.engine.impl.context.Context@getProcessEngineConfiguration().databaseTablePrefix}");
        } else {
            properties.put("prefix", this.databaseTablePrefix);
        }
        KoraProcessEngineConfiguration.initSqlSessionFactoryProperties((Properties)properties, (String)this.databaseTablePrefix, (String)this.databaseType);
        XMLConfigBuilder parser = new XMLConfigBuilder((Reader)reader, "", properties);
        Configuration parserConfiguration = parser.getConfiguration();
        parserConfiguration.getSqlFragments().putAll(this.getSqlSessionFactory().getConfiguration().getSqlFragments());
        parser.parse();
        return parserConfiguration;
    }

    protected InputStream getMyBatisXmlConfigurationSteamStageTwo() {
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE configuration PUBLIC \"-//mybatis.org//DTD Config 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-config.dtd\">\n<configuration>\n\t<settings>\n\t\t<setting name=\"lazyLoadingEnabled\" value=\"false\" />\n\t</settings>\n\t<mappers>\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Report.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Attachment.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Comment.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Execution.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricActivityInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricCaseActivityInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricDetail.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricIncident.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricIdentityLinkLog.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricProcessInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricCaseInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricStatistics.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricVariableInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricTaskInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricTaskInstanceReport.xml\" />\n" + (this.getHistoryLevel() != HistoryLevel.HISTORY_LEVEL_FULL ? "    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricJobLog.xml\" />\n" : "") + "    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricExternalTaskLog.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/UserOperationLogEntry.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/IdentityInfo.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/IdentityLink.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/SchemaLogEntry.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/TableData.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/TaskMetrics.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/VariableInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Statistics.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Metrics.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/ExternalTask.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Batch.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricBatch.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/TenantMembership.xml\" />\n    <!-- DMN -->\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricDecisionInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricDecisionInputInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricDecisionOutputInstance.xml\" />\n\t</mappers>\n</configuration>\n";
        return new ByteArrayInputStream(s.getBytes());
    }
}

