/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn;

import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.List;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@ConfigValueExtractor
public interface CamundaEngineBpmnConfig {
    public ParallelInitConfig parallelInitialization();

    public JobExecutorConfig jobExecutor();

    @Nullable
    public DeploymentConfig deployment();

    @Nullable
    public AdminConfig admin();

    public CamundaTelemetryConfig telemetry();

    @ConfigValueExtractor
    public static interface CamundaEngineTelemetryConfig
    extends TelemetryConfig.LogConfig {
        default public boolean stacktrace() {
            return true;
        }
    }

    @ConfigValueExtractor
    public static interface CamundaEngineLogConfig
    extends TelemetryConfig.LogConfig {
        default public boolean stacktrace() {
            return true;
        }
    }

    @ConfigValueExtractor
    public static interface CamundaTelemetryConfig
    extends TelemetryConfig {
        public CamundaEngineLogConfig logging();

        public TelemetryConfig.TracingConfig tracing();

        default public boolean engineTelemetryEnabled() {
            return false;
        }
    }

    @ConfigValueExtractor
    public static interface JobExecutorConfig {
        default public Integer corePoolSize() {
            return 5;
        }

        default public Integer maxPoolSize() {
            return 25;
        }

        default public Integer queueSize() {
            return 25;
        }

        default public Integer maxJobsPerAcquisition() {
            return Runtime.getRuntime().availableProcessors() * 2;
        }
    }

    @ConfigValueExtractor
    public static interface DeploymentConfig {
        @Nullable
        public String tenantId();

        default public String name() {
            return "KoraEngineAutoDeployment";
        }

        default public boolean deployChangedOnly() {
            return true;
        }

        public List<String> resources();

        @Nullable
        public Duration delay();
    }

    @ConfigValueExtractor
    public static interface FilterConfig {
        public String create();
    }

    @ConfigValueExtractor
    public static interface AdminConfig {
        public String id();

        public String password();

        @Nullable
        public String firstname();

        @Nullable
        public String lastname();

        @Nullable
        public String email();
    }

    @ConfigValueExtractor
    public static interface ParallelInitConfig {
        default public boolean enabled() {
            return true;
        }

        default public boolean validateIncompleteStatements() {
            return true;
        }
    }
}

