/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn.telemetry;

import jakarta.annotation.Nullable;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnLogger;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnMetrics;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnTelemetry;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnTracer;

public final class DefaultCamundaEngineBpmnTelemetry
implements CamundaEngineBpmnTelemetry {
    private final CamundaEngineBpmnMetrics metrics;
    private final CamundaEngineBpmnLogger logger;
    private final CamundaEngineBpmnTracer tracer;

    public DefaultCamundaEngineBpmnTelemetry(@Nullable CamundaEngineBpmnMetrics metrics, @Nullable CamundaEngineBpmnLogger logger, @Nullable CamundaEngineBpmnTracer tracer) {
        this.metrics = metrics;
        this.logger = logger;
        this.tracer = tracer;
    }

    @Override
    public CamundaEngineBpmnTelemetry.CamundaEngineTelemetryContext get(String javaDelegateName, DelegateExecution execution) {
        long start = System.nanoTime();
        if (this.metrics != null) {
            this.metrics.executionStarted(javaDelegateName, execution);
        }
        CamundaEngineBpmnTracer.CamundaEngineSpan span = this.tracer != null ? this.tracer.createSpan(javaDelegateName, execution) : null;
        if (this.logger != null) {
            this.logger.logStart(javaDelegateName, execution);
        }
        return exception -> {
            long end = System.nanoTime();
            long processingTime = end - start;
            if (this.metrics != null) {
                this.metrics.executionFinished(javaDelegateName, execution, processingTime, exception);
            }
            if (this.logger != null) {
                this.logger.logEnd(javaDelegateName, execution, processingTime, exception);
            }
            if (span != null) {
                span.close(exception);
            }
        };
    }
}

