/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest.telemetry;

import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import ru.tinkoff.kora.camunda.rest.CamundaRest;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestLogger;
import ru.tinkoff.kora.logging.common.arg.StructuredArgument;

public final class DefaultCamundaRestLogger
implements CamundaRestLogger {
    private static final Logger logger = LoggerFactory.getLogger(CamundaRest.class);
    private final boolean logStacktrace;

    public DefaultCamundaRestLogger(boolean stacktrace) {
        this.logStacktrace = stacktrace;
    }

    @Override
    public void logStart(String method, String path) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        Marker marker = StructuredArgument.marker((String)"httpRequest", gen -> {
            gen.writeStartObject();
            gen.writeStringField("operation", method);
            gen.writeEndObject();
        });
        logger.info(marker, "Camunda RestRequest received for {} {}", (Object)method, (Object)path);
    }

    @Override
    public void logEnd(String method, String path, int statusCode, long processingTime, @Nullable Throwable exception) {
        if (!logger.isWarnEnabled()) {
            return;
        }
        Marker marker = StructuredArgument.marker((String)"httpResponse", gen -> {
            gen.writeStartObject();
            gen.writeStringField("operation", method);
            gen.writeNumberField("processingTime", processingTime / 1000000L);
            gen.writeNumberField("statusCode", statusCode);
            if (exception != null) {
                String exceptionType = exception.getClass().getCanonicalName();
                gen.writeStringField("exceptionType", exceptionType);
            }
            gen.writeEndObject();
        });
        if (statusCode != -1) {
            if (this.logStacktrace && exception != null) {
                logger.warn(marker, "Camunda RestRequest failed with status code {} for {} {}", new Object[]{statusCode, method, path, exception});
            } else if (exception != null) {
                logger.warn(marker, "Camunda RestRequest failed with status code {} for {} {} with message: {}", new Object[]{statusCode, method, path, exception.getMessage()});
            } else if (statusCode >= 400) {
                logger.warn(marker, "Camunda RestRequest failed with status code {} for {} {}", new Object[]{statusCode, method, path});
            } else {
                logger.info(marker, "Camunda RestRequest responded with status code {} for {} {}", new Object[]{statusCode, method, path});
            }
        } else if (this.logStacktrace && exception != null) {
            logger.warn(marker, "Camunda RestRequest processing error for {}", (Object)method, (Object)exception);
        } else if (exception != null) {
            logger.warn(marker, "Camunda RestRequest processing error for {} with message {}", (Object)statusCode, (Object)exception.getMessage());
        } else {
            logger.warn(marker, "Camunda RestRequest processing error for {}", (Object)method);
        }
    }
}

