/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest.telemetry;

import io.undertow.util.HeaderMap;
import jakarta.annotation.Nullable;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestLogger;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestMetrics;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTelemetry;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTracer;

public final class DefaultCamundaRestTelemetry
implements CamundaRestTelemetry {
    private static final String UNMATCHED_ROUTE_TEMPLATE = "UNKNOWN_ROUTE";
    private final CamundaRestMetrics metrics;
    private final CamundaRestLogger logger;
    private final CamundaRestTracer tracer;

    public DefaultCamundaRestTelemetry(@Nullable CamundaRestMetrics metrics, @Nullable CamundaRestLogger logger, @Nullable CamundaRestTracer tracer) {
        this.metrics = metrics;
        this.logger = logger;
        this.tracer = tracer;
    }

    @Override
    public CamundaRestTelemetry.CamundaRestTelemetryContext get(String method, String path, HeaderMap headerMap) {
        CamundaRestTracer.CamundaRestSpan span;
        String routeTelemetry;
        long start = System.nanoTime();
        String string = routeTelemetry = path != null ? path : UNMATCHED_ROUTE_TEMPLATE;
        if (this.metrics != null) {
            this.metrics.requestStarted(method, routeTelemetry);
        }
        if (path != null) {
            span = this.tracer != null ? this.tracer.createSpan(method, path, headerMap) : null;
            if (this.logger != null) {
                this.logger.logStart(method, path);
            }
        } else {
            span = null;
        }
        return (statusCode, exception) -> {
            long end = System.nanoTime();
            long processingTime = end - start;
            if (this.metrics != null) {
                this.metrics.requestFinished(method, routeTelemetry, statusCode, processingTime, exception);
            }
            if (this.logger != null) {
                this.logger.logEnd(method, routeTelemetry, statusCode, processingTime, exception);
            }
            if (span != null) {
                span.close(statusCode, exception);
            }
        };
    }
}

