/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest.undertow;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.camunda.rest.CamundaRestConfig;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTelemetry;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTelemetryFactory;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.common.readiness.ReadinessProbeFailure;
import ru.tinkoff.kora.common.util.TimeUtils;

final class UndertowCamundaHttpServer
implements Lifecycle,
ReadinessProbe {
    private static final Logger logger = LoggerFactory.getLogger(UndertowCamundaHttpServer.class);
    private final AtomicReference<HttpServerState> state = new AtomicReference<HttpServerState>(HttpServerState.INIT);
    private final String name;
    private final ValueOf<CamundaRestConfig> config;
    private final CamundaRestTelemetry telemetry;
    private final GracefulShutdownHandler gracefulShutdown;
    private volatile Undertow undertow;

    UndertowCamundaHttpServer(ValueOf<CamundaRestConfig> config, ValueOf<HttpHandler> publicApiHandler, CamundaRestTelemetryFactory telemetryFactory) {
        this.name = "Camunda";
        this.config = config;
        this.telemetry = telemetryFactory.get(((CamundaRestConfig)config.get()).telemetry());
        this.gracefulShutdown = new GracefulShutdownHandler(ex -> {
            CamundaRestTelemetry.CamundaRestTelemetryContext telemetryContext = this.telemetry.get(ex.getRequestMethod().toString(), ex.getRelativePath(), ex.getRequestHeaders());
            ex.addExchangeCompleteListener((ext, listener) -> {
                telemetryContext.close(ext.getStatusCode(), null);
                listener.proceed();
            });
            try {
                ((HttpHandler)publicApiHandler.get()).handleRequest(ex);
            }
            catch (Exception e) {
                telemetryContext.close(ex.getStatusCode(), e);
                throw e;
            }
        });
    }

    public void init() {
        if (((CamundaRestConfig)this.config.get()).enabled()) {
            logger.debug("{} HTTP Server (Undertow) starting...", (Object)this.name);
            long started = TimeUtils.started();
            this.gracefulShutdown.start();
            this.undertow = Undertow.builder().addHttpListener(((CamundaRestConfig)this.config.get()).port().intValue(), "0.0.0.0", (HttpHandler)this.gracefulShutdown).build();
            this.undertow.start();
            this.state.set(HttpServerState.RUN);
            logger.info("{} HTTP Server (Undertow) started in {}", (Object)this.name, (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public void release() {
        if (this.undertow != null) {
            this.state.set(HttpServerState.SHUTDOWN);
            try {
                Thread.sleep(((CamundaRestConfig)this.config.get()).shutdownWait().toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.debug("{} HTTP Server (Undertow) stopping...", (Object)this.name);
            long started = TimeUtils.started();
            this.gracefulShutdown.shutdown();
            try {
                logger.debug("{} HTTP Server (Undertow) awaiting graceful shutdown...", (Object)this.name);
                this.gracefulShutdown.awaitShutdown();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.undertow.stop();
            this.undertow = null;
            logger.info("{} HTTP Server (Undertow) stopped in {}", (Object)this.name, (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public ReadinessProbeFailure probe() {
        return switch (this.state.get()) {
            default -> throw new IncompatibleClassChangeError();
            case HttpServerState.INIT -> new ReadinessProbeFailure(this.name + " HTTP Server (Undertow) init");
            case HttpServerState.RUN -> null;
            case HttpServerState.SHUTDOWN -> new ReadinessProbeFailure(this.name + "HTTP Server (Undertow) shutdown");
        };
    }

    private static enum HttpServerState {
        INIT,
        RUN,
        SHUTDOWN;

    }
}

