/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import jakarta.ws.rs.core.Application;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.core.ResteasyDeploymentImpl;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.camunda.rest.CamundaRestConfig;
import ru.tinkoff.kora.common.util.TimeUtils;

final class UndertowCamundaRestHttpHandler
implements Lifecycle,
Wrapped<HttpHandler> {
    private static final Logger logger = LoggerFactory.getLogger(UndertowCamundaRestHttpHandler.class);
    private final Application application;
    private final CamundaRestConfig camundaRestConfig;
    private volatile DeploymentManager deploymentManager;
    private volatile HttpHandler realhttpHandler;

    UndertowCamundaRestHttpHandler(List<Application> applications, CamundaRestConfig camundaRestConfig) {
        final HashSet classes = new HashSet();
        final HashMap props = new HashMap();
        for (Application app : applications) {
            classes.addAll(app.getClasses());
            props.putAll(app.getProperties());
        }
        this.application = new Application(){

            public Set<Class<?>> getClasses() {
                return classes;
            }

            public Map<String, Object> getProperties() {
                return props;
            }
        };
        this.camundaRestConfig = camundaRestConfig;
    }

    public HttpHandler value() {
        return this.realhttpHandler;
    }

    public void init() throws Exception {
        logger.debug("Camunda Rest Handler (Undertow) configuring...");
        long started = TimeUtils.started();
        ResteasyDeploymentImpl deployment = new ResteasyDeploymentImpl();
        deployment.setApplication(this.application);
        deployment.start();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        UndertowJaxrsServer server = new UndertowJaxrsServer();
        DeploymentInfo di = server.undertowDeployment((ResteasyDeployment)deployment);
        ClassLoader classLoader = UndertowCamundaRestHttpHandler.class.getClassLoader();
        di.setClassLoader(classLoader);
        di.setContextPath(this.camundaRestConfig.path());
        di.setDeploymentName("ResteasyCamundaKora");
        this.deploymentManager = container.addDeployment(di);
        this.deploymentManager.deploy();
        root.addPrefixPath(this.camundaRestConfig.path(), this.deploymentManager.start());
        this.realhttpHandler = root;
        logger.info("Camunda Rest Handler (Undertow) configured in {}", (Object)TimeUtils.tookForLogging((long)started));
    }

    public void release() throws Exception {
        logger.debug("Camunda Rest Handler (Undertow) stopping...");
        long started = TimeUtils.started();
        this.deploymentManager.stop();
        logger.info("Camunda Rest Handler (Undertow) stopped in {}", (Object)TimeUtils.tookForLogging((long)started));
    }
}

