/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.camunda.rest.CamundaRestConfig;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestLogger;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestLoggerFactory;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestMetrics;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestMetricsFactory;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTelemetry;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTelemetryFactory;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTracer;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTracerFactory;
import ru.tinkoff.kora.camunda.rest.telemetry.DefaultCamundaRestTelemetry;

public final class DefaultCamundaRestTelemetryFactory
implements CamundaRestTelemetryFactory {
    private static final CamundaRestTelemetry.CamundaRestTelemetryContext EMPTY_CTX = (s, r, h, ex) -> {};
    private static final CamundaRestTelemetry EMPTY = (s, host, m, p, pt, h, q, b) -> EMPTY_CTX;
    @Nullable
    private final CamundaRestLoggerFactory logger;
    @Nullable
    private final CamundaRestMetricsFactory metrics;
    @Nullable
    private final CamundaRestTracerFactory tracer;

    public DefaultCamundaRestTelemetryFactory(@Nullable CamundaRestLoggerFactory logger, @Nullable CamundaRestMetricsFactory metrics, @Nullable CamundaRestTracerFactory tracer) {
        this.logger = logger;
        this.metrics = metrics;
        this.tracer = tracer;
    }

    @Override
    public CamundaRestTelemetry get(CamundaRestConfig.CamundaRestTelemetryConfig config) {
        CamundaRestTracer tracer;
        CamundaRestMetrics metrics = this.metrics == null ? null : this.metrics.get(config.metrics());
        CamundaRestLogger logging = this.logger == null ? null : this.logger.get(config.logging());
        CamundaRestTracer camundaRestTracer = tracer = this.tracer == null ? null : this.tracer.get(config.tracing());
        if (metrics == null && logging == null && tracer == null) {
            return EMPTY;
        }
        return new DefaultCamundaRestTelemetry(metrics, logging, tracer);
    }
}

