/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest;

import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Application;
import java.util.HashSet;
import java.util.Set;
import org.camunda.bpm.engine.rest.impl.CamundaRestResources;
import ru.tinkoff.kora.camunda.rest.CamundaRest;
import ru.tinkoff.kora.camunda.rest.CamundaRestConfig;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestLoggerFactory;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestMetricsFactory;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTelemetryFactory;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTracerFactory;
import ru.tinkoff.kora.camunda.rest.telemetry.DefaultCamundaRestTelemetryFactory;
import ru.tinkoff.kora.camunda.rest.telemetry.Slf4JCamundaRestLoggerFactory;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public interface CamundaRestModule {
    @DefaultComponent
    default public CamundaRestLoggerFactory camundaRestLoggerFactory() {
        return new Slf4JCamundaRestLoggerFactory();
    }

    @DefaultComponent
    default public CamundaRestTelemetryFactory camundaRestTelemetryFactory(@Nullable CamundaRestLoggerFactory logger, @Nullable CamundaRestMetricsFactory metrics, @Nullable CamundaRestTracerFactory tracer) {
        return new DefaultCamundaRestTelemetryFactory(logger, metrics, tracer);
    }

    default public CamundaRestConfig camundaRestConfig(Config config, ConfigValueExtractor<CamundaRestConfig> extractor) {
        return (CamundaRestConfig)extractor.extract(config.get("camunda.rest"));
    }

    @Tag(value={CamundaRest.class})
    default public Application camundaRestApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                HashSet set = new HashSet();
                set.addAll(CamundaRestResources.getResourceClasses());
                set.addAll(CamundaRestResources.getConfigurationClasses());
                return set;
            }
        };
    }
}

