/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest.undertow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import ru.tinkoff.kora.http.server.common.router.PathTemplate;
import ru.tinkoff.kora.http.server.common.router.PathTemplateMatcher;

final class UndertowPathMatcher {
    private final Map<String, PathTemplateMatcher<String>> pathTemplateMatcher = new HashMap<String, PathTemplateMatcher<String>>();

    UndertowPathMatcher(List<HttpMethodPath> methods) {
        PathTemplateMatcher allMethodMatchers = new PathTemplateMatcher();
        for (HttpMethodPath h : methods) {
            String route = h.routeTemplate();
            PathTemplateMatcher methodMatchers = this.pathTemplateMatcher.computeIfAbsent(h.method().toUpperCase(Locale.ROOT), k -> new PathTemplateMatcher());
            Map.Entry oldValue = methodMatchers.add(route, (Object)route);
            if (oldValue != null) {
                throw new IllegalStateException("Can't add path template %s, matcher already contains an equivalent pattern %s".formatted(route, ((PathTemplate)oldValue.getKey()).templateString()));
            }
            ArrayList<String> otherMethods = new ArrayList<String>(List.of(h.method()));
            Map.Entry oldAllMethodValue = allMethodMatchers.add(route, otherMethods);
            if (oldAllMethodValue == null) continue;
            otherMethods.addAll((Collection)oldAllMethodValue.getValue());
        }
    }

    Optional<Match> getMatch(String method, String path) {
        PathTemplateMatcher.PathTemplateMatch pathTemplateMatch;
        PathTemplateMatcher<String> methodMatchers = this.pathTemplateMatcher.get(method);
        PathTemplateMatcher.PathTemplateMatch pathTemplateMatch2 = pathTemplateMatch = methodMatchers == null ? null : methodMatchers.match(path);
        if (pathTemplateMatch == null) {
            return Optional.empty();
        }
        Map templateParameters = pathTemplateMatch.parameters();
        String routeTemplate = pathTemplateMatch.matchedTemplate();
        return Optional.of(new Match(method, routeTemplate, templateParameters));
    }

    record HttpMethodPath(String method, String routeTemplate) {
    }

    record Match(String method, String pathTemplate, Map<String, String> pathParameters) {
    }
}

