/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest.undertow;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.camunda.rest.CamundaRestConfig;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.common.readiness.ReadinessProbeFailure;
import ru.tinkoff.kora.common.util.TimeUtils;

final class UndertowCamundaHttpServer
implements Lifecycle,
ReadinessProbe {
    private static final Logger logger = LoggerFactory.getLogger(UndertowCamundaHttpServer.class);
    private final AtomicReference<HttpServerState> state = new AtomicReference<HttpServerState>(HttpServerState.INIT);
    private final ValueOf<CamundaRestConfig> config;
    private final GracefulShutdownHandler gracefulShutdown;
    private volatile Undertow undertow;

    UndertowCamundaHttpServer(ValueOf<CamundaRestConfig> config, ValueOf<HttpHandler> publicApiHandler) {
        this.config = config;
        this.gracefulShutdown = new GracefulShutdownHandler(exch -> {
            try {
                ((HttpHandler)publicApiHandler.get()).handleRequest(exch);
            }
            catch (Exception e) {
                exch.setStatusCode(500);
                exch.endExchange();
                e.printStackTrace();
            }
        });
    }

    public void init() {
        if (((CamundaRestConfig)this.config.get()).enabled()) {
            logger.debug("Camunda HTTP Server (Undertow) starting...");
            long started = TimeUtils.started();
            this.gracefulShutdown.start();
            this.undertow = Undertow.builder().addHttpListener(((CamundaRestConfig)this.config.get()).port().intValue(), "0.0.0.0", (HttpHandler)this.gracefulShutdown).build();
            this.undertow.start();
            this.state.set(HttpServerState.RUN);
            logger.info("Camunda HTTP Server (Undertow) started in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public void release() {
        if (this.undertow != null) {
            this.state.set(HttpServerState.SHUTDOWN);
            long started = TimeUtils.started();
            this.gracefulShutdown.shutdown();
            Duration shutdownAwait = ((CamundaRestConfig)this.config.get()).shutdownWait();
            try {
                logger.debug("Camunda HTTP Server (Undertow) awaiting graceful shutdown...");
                if (!this.gracefulShutdown.awaitShutdown(shutdownAwait.toMillis())) {
                    logger.warn("Camunda HTTP Server (Undertow) failed completing graceful shutdown in {}", (Object)shutdownAwait);
                }
            }
            catch (InterruptedException e) {
                logger.warn("Camunda HTTP Server (Undertow) failed completing graceful shutdown in {}", (Object)shutdownAwait, (Object)e);
            }
            this.undertow.stop();
            this.undertow = null;
            logger.info("Camunda HTTP Server (Undertow) stopped in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public ReadinessProbeFailure probe() {
        return switch (this.state.get()) {
            default -> throw new IncompatibleClassChangeError();
            case HttpServerState.INIT -> new ReadinessProbeFailure("Camunda HTTP Server (Undertow) init");
            case HttpServerState.RUN -> null;
            case HttpServerState.SHUTDOWN -> new ReadinessProbeFailure("CamundaHTTP Server (Undertow) shutdown");
        };
    }

    private static enum HttpServerState {
        INIT,
        RUN,
        SHUTDOWN;

    }
}

