/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest;

import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@ConfigValueExtractor
public interface CamundaRestConfig {
    default public boolean enabled() {
        return false;
    }

    default public String path() {
        return "/engine-rest";
    }

    default public Integer port() {
        return 8081;
    }

    default public Duration shutdownWait() {
        return Duration.ofSeconds(30L);
    }

    public CamundaOpenApiConfig openapi();

    public CamundaRestTelemetryConfig telemetry();

    @ConfigValueExtractor
    public static interface CamundaOpenApiConfig {
        default public List<String> file() {
            return List.of("openapi.json");
        }

        default public boolean enabled() {
            return false;
        }

        default public String endpoint() {
            return "/openapi";
        }

        public SwaggerUIConfig swaggerui();

        public RapidocConfig rapidoc();

        @ConfigValueExtractor
        public static interface RapidocConfig {
            default public boolean enabled() {
                return false;
            }

            default public String endpoint() {
                return "/rapidoc";
            }
        }

        @ConfigValueExtractor
        public static interface SwaggerUIConfig {
            default public boolean enabled() {
                return false;
            }

            default public String endpoint() {
                return "/swagger-ui";
            }
        }
    }

    @ConfigValueExtractor
    public static interface CamundaRestLoggerConfig
    extends TelemetryConfig.LogConfig {
        default public boolean stacktrace() {
            return true;
        }

        default public Set<String> maskQueries() {
            return Collections.emptySet();
        }

        default public Set<String> maskHeaders() {
            return Set.of("authorization");
        }

        default public String mask() {
            return "***";
        }

        @Nullable
        public Boolean pathTemplate();
    }

    @ConfigValueExtractor
    public static interface CamundaRestTelemetryConfig
    extends TelemetryConfig {
        public CamundaRestLoggerConfig logging();
    }
}

