/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.camunda.rest.CamundaRestConfig;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $CamundaRestConfig_ConfigValueExtractor
implements ConfigValueExtractor<CamundaRestConfig> {
    public static final CamundaRestConfig_Defaults DEFAULTS = new CamundaRestConfig_Defaults();
    private static final PathElement.Key _enabled_path = PathElement.get((String)"enabled");
    private static final PathElement.Key _path_path = PathElement.get((String)"path");
    private static final PathElement.Key _port_path = PathElement.get((String)"port");
    private static final PathElement.Key _shutdownWait_path = PathElement.get((String)"shutdownWait");
    private static final PathElement.Key _openapi_path = PathElement.get((String)"openapi");
    private static final PathElement.Key _telemetry_path = PathElement.get((String)"telemetry");
    private final ConfigValueExtractor<Duration> shutdownWait_parser;
    private final ConfigValueExtractor<CamundaRestConfig.CamundaOpenApiConfig> openapi_parser;
    private final ConfigValueExtractor<CamundaRestConfig.CamundaRestTelemetryConfig> telemetry_parser;

    public $CamundaRestConfig_ConfigValueExtractor(ConfigValueExtractor<Duration> extractor1, ConfigValueExtractor<CamundaRestConfig.CamundaOpenApiConfig> extractor2, ConfigValueExtractor<CamundaRestConfig.CamundaRestTelemetryConfig> extractor3) {
        this.shutdownWait_parser = extractor1;
        this.openapi_parser = extractor2;
        this.telemetry_parser = extractor3;
    }

    public CamundaRestConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        boolean enabled = this.parse_enabled(_config);
        String path = this.parse_path(_config);
        Integer port = this.parse_port(_config);
        Duration shutdownWait = this.parse_shutdownWait(_config);
        CamundaRestConfig.CamundaOpenApiConfig openapi = this.parse_openapi(_config);
        CamundaRestConfig.CamundaRestTelemetryConfig telemetry = this.parse_telemetry(_config);
        return new CamundaRestConfig_Impl(enabled, path, port, shutdownWait, openapi, telemetry);
    }

    private boolean parse_enabled(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_enabled_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.enabled();
            return defaultValue;
        }
        return value.asBoolean();
    }

    private String parse_path(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_path_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            String defaultValue = DEFAULTS.path();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
            }
            return defaultValue;
        }
        return value.asString();
    }

    private Integer parse_port(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_port_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Integer defaultValue = DEFAULTS.port();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
            }
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private Duration parse_shutdownWait(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_shutdownWait_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.shutdownWait();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.shutdownWait_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private CamundaRestConfig.CamundaOpenApiConfig parse_openapi(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_openapi_path);
        CamundaRestConfig.CamundaOpenApiConfig parsed = (CamundaRestConfig.CamundaOpenApiConfig)this.openapi_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private CamundaRestConfig.CamundaRestTelemetryConfig parse_telemetry(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_telemetry_path);
        CamundaRestConfig.CamundaRestTelemetryConfig parsed = (CamundaRestConfig.CamundaRestTelemetryConfig)this.telemetry_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public record CamundaRestConfig_Impl(boolean enabled, @Nonnull String path, @Nonnull Integer port, @Nonnull Duration shutdownWait, @Nonnull CamundaRestConfig.CamundaOpenApiConfig openapi, @Nonnull CamundaRestConfig.CamundaRestTelemetryConfig telemetry) implements CamundaRestConfig
    {
        public CamundaRestConfig_Impl {
            Objects.requireNonNull(path);
            Objects.requireNonNull(port);
            Objects.requireNonNull(shutdownWait);
            Objects.requireNonNull(openapi);
            Objects.requireNonNull(telemetry);
        }
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public static final class CamundaRestConfig_Defaults
    implements CamundaRestConfig {
        @Override
        public CamundaRestConfig.CamundaOpenApiConfig openapi() {
            return null;
        }

        @Override
        public CamundaRestConfig.CamundaRestTelemetryConfig telemetry() {
            return null;
        }
    }
}

