/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.rest.telemetry;

import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Map;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestLogger;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestMetrics;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTelemetry;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestTracer;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;
import ru.tinkoff.kora.http.common.header.HttpHeaders;

public final class DefaultCamundaRestTelemetry
implements CamundaRestTelemetry {
    private static final CamundaRestTelemetry.CamundaRestTelemetryContext EMPTY_CTX = (s, r, h, ex) -> {};
    private static final String UNMATCHED_ROUTE_TEMPLATE = "UNKNOWN_ROUTE";
    @Nullable
    private final CamundaRestMetrics metrics;
    @Nullable
    private final CamundaRestLogger logger;
    @Nullable
    private final CamundaRestTracer tracer;

    public DefaultCamundaRestTelemetry(@Nullable CamundaRestMetrics metrics, @Nullable CamundaRestLogger logger, @Nullable CamundaRestTracer tracer) {
        this.metrics = metrics;
        this.logger = logger;
        this.tracer = tracer;
    }

    @Override
    public CamundaRestTelemetry.CamundaRestTelemetryContext get(String scheme, String host, String method, String path, @Nullable String routeTemplate, HttpHeaders headers, Map<String, ? extends Collection<String>> queryParams, HttpBodyInput body) {
        CamundaRestTracer.CamundaRestSpan span;
        CamundaRestMetrics metrics = this.metrics;
        CamundaRestLogger logger = this.logger;
        CamundaRestTracer tracer = this.tracer;
        if (!(metrics != null || tracer != null || logger != null && logger.isEnabled())) {
            return EMPTY_CTX;
        }
        long start = System.nanoTime();
        if (metrics != null) {
            String pathTemplate = routeTemplate != null ? routeTemplate : UNMATCHED_ROUTE_TEMPLATE;
            metrics.requestStarted(method, pathTemplate, host, scheme);
        }
        if (routeTemplate != null) {
            if (logger != null) {
                logger.logStart(method, path, routeTemplate, queryParams, headers);
            }
            span = tracer != null ? tracer.createSpan(scheme, host, method, path, routeTemplate, headers, queryParams, body) : null;
        } else {
            span = null;
        }
        return (statusCode, resultCode, responseHeaders, exception) -> {
            long end = System.nanoTime();
            long processingTime = end - start;
            if (metrics != null) {
                String pathTemplate = routeTemplate != null ? routeTemplate : UNMATCHED_ROUTE_TEMPLATE;
                metrics.requestFinished(statusCode, resultCode, scheme, host, method, pathTemplate, responseHeaders, processingTime, exception);
            }
            if (routeTemplate != null) {
                if (logger != null) {
                    logger.logEnd(statusCode, resultCode, method, path, routeTemplate, processingTime, queryParams, responseHeaders, exception);
                }
                if (span != null) {
                    span.close(statusCode, resultCode, exception);
                }
            }
        };
    }
}

