/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.camunda.zeebe.worker.ZeebeClientConfig;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $ZeebeClientConfig_ConfigValueExtractor
implements ConfigValueExtractor<ZeebeClientConfig> {
    public static final ZeebeClientConfig_Defaults DEFAULTS = new ZeebeClientConfig_Defaults();
    private static final PathElement.Key _executionThreads_path = PathElement.get((String)"executionThreads");
    private static final PathElement.Key _tls_path = PathElement.get((String)"tls");
    private static final PathElement.Key _keepAlive_path = PathElement.get((String)"keepAlive");
    private static final PathElement.Key _certificatePath_path = PathElement.get((String)"certificatePath");
    private static final PathElement.Key _initializationFailTimeout_path = PathElement.get((String)"initializationFailTimeout");
    private static final PathElement.Key _grpc_path = PathElement.get((String)"grpc");
    private static final PathElement.Key _rest_path = PathElement.get((String)"rest");
    private static final PathElement.Key _deployment_path = PathElement.get((String)"deployment");
    private static final PathElement.Key _telemetry_path = PathElement.get((String)"telemetry");
    private final ConfigValueExtractor<Duration> extractor1;
    private final ConfigValueExtractor<Duration> keepAlive_parser;
    private final ConfigValueExtractor<Duration> initializationFailTimeout_parser;
    private final ConfigValueExtractor<ZeebeClientConfig.GrpcConfig> extractor2;
    private final ConfigValueExtractor<ZeebeClientConfig.GrpcConfig> grpc_parser;
    private final ConfigValueExtractor<ZeebeClientConfig.RestConfig> extractor3;
    private final ConfigValueExtractor<ZeebeClientConfig.RestConfig> rest_parser;
    private final ConfigValueExtractor<ZeebeClientConfig.DeploymentConfig> extractor4;
    private final ConfigValueExtractor<ZeebeClientConfig.DeploymentConfig> deployment_parser;
    private final ConfigValueExtractor<TelemetryConfig> extractor5;
    private final ConfigValueExtractor<TelemetryConfig> telemetry_parser;

    public $ZeebeClientConfig_ConfigValueExtractor(ConfigValueExtractor<Duration> extractor1, ConfigValueExtractor<ZeebeClientConfig.GrpcConfig> extractor2, ConfigValueExtractor<ZeebeClientConfig.RestConfig> extractor3, ConfigValueExtractor<ZeebeClientConfig.DeploymentConfig> extractor4, ConfigValueExtractor<TelemetryConfig> extractor5) {
        this.extractor1 = extractor1;
        this.keepAlive_parser = extractor1;
        this.initializationFailTimeout_parser = extractor1;
        this.extractor2 = extractor2;
        this.grpc_parser = extractor2;
        this.extractor3 = extractor3;
        this.rest_parser = extractor3;
        this.extractor4 = extractor4;
        this.deployment_parser = extractor4;
        this.extractor5 = extractor5;
        this.telemetry_parser = extractor5;
    }

    public ZeebeClientConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        int executionThreads = this.parse_executionThreads(_config);
        boolean tls = this.parse_tls(_config);
        Duration keepAlive = this.parse_keepAlive(_config);
        String certificatePath = this.parse_certificatePath(_config);
        Duration initializationFailTimeout = this.parse_initializationFailTimeout(_config);
        ZeebeClientConfig.GrpcConfig grpc = this.parse_grpc(_config);
        ZeebeClientConfig.RestConfig rest = this.parse_rest(_config);
        ZeebeClientConfig.DeploymentConfig deployment = this.parse_deployment(_config);
        TelemetryConfig telemetry = this.parse_telemetry(_config);
        return new ZeebeClientConfig_Impl(executionThreads, tls, keepAlive, certificatePath, initializationFailTimeout, grpc, rest, deployment, telemetry);
    }

    private int parse_executionThreads(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_executionThreads_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.executionThreads();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private boolean parse_tls(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_tls_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.tls();
            return defaultValue;
        }
        return value.asBoolean();
    }

    private Duration parse_keepAlive(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_keepAlive_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.keepAlive();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.keepAlive_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Nullable
    private String parse_certificatePath(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_certificatePath_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return value.asString();
    }

    @Nullable
    private Duration parse_initializationFailTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_initializationFailTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (Duration)this.initializationFailTimeout_parser.extract(value);
    }

    private ZeebeClientConfig.GrpcConfig parse_grpc(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_grpc_path);
        ZeebeClientConfig.GrpcConfig parsed = (ZeebeClientConfig.GrpcConfig)this.grpc_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Nullable
    private ZeebeClientConfig.RestConfig parse_rest(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_rest_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (ZeebeClientConfig.RestConfig)this.rest_parser.extract(value);
    }

    private ZeebeClientConfig.DeploymentConfig parse_deployment(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_deployment_path);
        ZeebeClientConfig.DeploymentConfig parsed = (ZeebeClientConfig.DeploymentConfig)this.deployment_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private TelemetryConfig parse_telemetry(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_telemetry_path);
        TelemetryConfig parsed = (TelemetryConfig)this.telemetry_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public record ZeebeClientConfig_Impl(int executionThreads, boolean tls, @Nonnull Duration keepAlive, String certificatePath, Duration initializationFailTimeout, @Nonnull ZeebeClientConfig.GrpcConfig grpc, ZeebeClientConfig.RestConfig rest, @Nonnull ZeebeClientConfig.DeploymentConfig deployment, @Nonnull TelemetryConfig telemetry) implements ZeebeClientConfig
    {
        public ZeebeClientConfig_Impl {
            Objects.requireNonNull(keepAlive);
            Objects.requireNonNull(grpc);
            Objects.requireNonNull(deployment);
            Objects.requireNonNull(telemetry);
        }
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public static final class ZeebeClientConfig_Defaults
    implements ZeebeClientConfig {
        @Override
        public String certificatePath() {
            return null;
        }

        @Override
        public Duration initializationFailTimeout() {
            return null;
        }

        @Override
        public ZeebeClientConfig.GrpcConfig grpc() {
            return null;
        }

        @Override
        public ZeebeClientConfig.RestConfig rest() {
            return null;
        }

        @Override
        public ZeebeClientConfig.DeploymentConfig deployment() {
            return null;
        }

        @Override
        public TelemetryConfig telemetry() {
            return null;
        }
    }
}

