/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.impl.util.VersionUtil;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import jakarta.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import ru.tinkoff.grpc.client.GrpcClientChannelFactory;
import ru.tinkoff.grpc.client.config.DefaultServiceConfig;
import ru.tinkoff.grpc.client.config.GrpcClientConfig;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetryFactory;
import ru.tinkoff.kora.application.graph.All;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.camunda.zeebe.worker.ZeebeClientConfig;
import ru.tinkoff.kora.camunda.zeebe.worker.ZeebeManagedChannelLifecycle;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

final class ZeebeManagedChannelFactory {
    private ZeebeManagedChannelFactory() {
    }

    static Wrapped<ManagedChannel> build(ZeebeClientConfig clientConfig, All<ClientInterceptor> interceptors, GrpcClientTelemetryFactory clientTelemetryFactory, GrpcClientChannelFactory clientChannelFactory) {
        GrpcClientConfig grpcClientConfig = ZeebeManagedChannelFactory.getZeebeGrpcConfig(clientConfig);
        GrpcClientChannelFactory grpcClientChannelFactory = ZeebeManagedChannelFactory.getZeebeClientChannelFactory(clientChannelFactory, clientConfig);
        String serviceName = ZeebeClient.class.getCanonicalName();
        ServiceDescriptor descriptor = new ServiceDescriptor(serviceName, new MethodDescriptor[0]);
        return new ZeebeManagedChannelLifecycle(grpcClientConfig, null, (List<ClientInterceptor>)interceptors, clientTelemetryFactory, grpcClientChannelFactory, descriptor);
    }

    private static GrpcClientConfig getZeebeGrpcConfig(final ZeebeClientConfig clientConfig) {
        return new GrpcClientConfig(){

            public String url() {
                return clientConfig.grpc().url();
            }

            @Nullable
            public Duration timeout() {
                return null;
            }

            public TelemetryConfig telemetry() {
                return clientConfig.telemetry();
            }

            @Nullable
            public DefaultServiceConfig defaultServiceConfig() {
                return null;
            }
        };
    }

    private static GrpcClientChannelFactory getZeebeClientChannelFactory(final GrpcClientChannelFactory factory, final ZeebeClientConfig clientConfig) {
        return new GrpcClientChannelFactory(){

            public ManagedChannelBuilder<?> forAddress(SocketAddress serverAddress) {
                return this.configure(factory.forAddress(serverAddress));
            }

            public ManagedChannelBuilder<?> forAddress(SocketAddress serverAddress, ChannelCredentials creds) {
                return this.configure(factory.forAddress(serverAddress, creds));
            }

            public ManagedChannelBuilder<?> forTarget(String target) {
                return this.configure(factory.forTarget(target));
            }

            public ManagedChannelBuilder<?> forTarget(String target, ChannelCredentials creds) {
                return this.configure(factory.forTarget(target, creds));
            }

            private ManagedChannelBuilder<?> configure(ManagedChannelBuilder<?> builder) {
                builder.keepAliveTime(clientConfig.keepAlive().toMillis(), TimeUnit.MILLISECONDS);
                builder.userAgent("zeebe-client-kora/" + VersionUtil.getVersion());
                builder.maxInboundMessageSize((int)clientConfig.grpc().maxMessageSize().toBytes());
                if (clientConfig.grpc().retryPolicy().enabled()) {
                    Map<String, Object> serviceConfig = ZeebeManagedChannelFactory.getServiceConfig(clientConfig);
                    builder.defaultServiceConfig(serviceConfig);
                    builder.enableRetry();
                }
                return builder;
            }
        };
    }

    private static Map<String, Object> getServiceConfig(ZeebeClientConfig clientConfig) {
        List<Map<String, String>> services1 = ZeebeManagedChannelFactory.getServices("ActivateJobs", "CancelProcessInstance", "CompleteJob", "DeleteResource", "EvaluateDecision", "FailJob", "ResolveIncident", "SetVariables", "StreamActivatedJobs", "Topology", "MigrateProcessInstance");
        List<Map<String, String>> services2 = ZeebeManagedChannelFactory.getServices("BroadcastSignal", "CreateProcessInstance", "CreateProcessInstanceWithResult", "DeployProcess", "DeployResource", "ModifyProcessInstance", "PublishMessage", "ThrowError", "UpdateJobRetries", "UpdateJobTimeout");
        return Map.of("methodConfig", List.of(Map.of("name", services1, "waitForReady", true, "retryPolicy", Map.of("maxAttempts", Double.valueOf(clientConfig.grpc().retryPolicy().attempts()), "initialBackoff", (double)clientConfig.grpc().retryPolicy().delay().toMillis() / 1000.0 + "s", "maxBackoff", (double)clientConfig.grpc().retryPolicy().delayMax().toMillis() / 1000.0 + "s", "backoffMultiplier", clientConfig.grpc().retryPolicy().step(), "retryableStatusCodes", List.of("UNAVAILABLE", "RESOURCE_EXHAUSTED", "DEADLINE_EXCEEDED"))), Map.of("name", services2, "waitForReady", true, "retryPolicy", Map.of("maxAttempts", Double.valueOf(clientConfig.grpc().retryPolicy().attempts()), "initialBackoff", (double)clientConfig.grpc().retryPolicy().delay().toMillis() / 1000.0 + "s", "maxBackoff", (double)clientConfig.grpc().retryPolicy().delayMax().toMillis() / 1000.0 + "s", "backoffMultiplier", clientConfig.grpc().retryPolicy().step(), "retryableStatusCodes", List.of("UNAVAILABLE", "RESOURCE_EXHAUSTED")))), "healthCheckConfig", Map.of("serviceName", "gateway_protocol.Gateway"));
    }

    private static List<Map<String, String>> getServices(String ... services) {
        ArrayList<Map<String, String>> serviceList = new ArrayList<Map<String, String>>();
        for (String service : services) {
            serviceList.add(Map.of("service", "gateway_protocol.Gateway", "method", service));
        }
        return serviceList;
    }
}

