/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.camunda.zeebe.worker.ZeebeClientConfig;
import ru.tinkoff.kora.common.util.TimeUtils;

public final class ZeebeResourceDeployment
implements Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ZeebeClient client;
    private final ZeebeClientConfig.DeploymentConfig deploymentConfig;

    public ZeebeResourceDeployment(ZeebeClient client, ZeebeClientConfig.DeploymentConfig deploymentConfig) {
        this.client = client;
        this.deploymentConfig = deploymentConfig;
    }

    public void init() throws Exception {
        List<String> locations = this.deploymentConfig.resources();
        if (!locations.isEmpty()) {
            logger.debug("Zeebe resources deploying...");
            long started = TimeUtils.started();
            Set<String> normalizedLocations = locations.stream().map(location -> {
                if (location.startsWith("classpath:")) {
                    return location.substring(10);
                }
                logger.warn("Only locations with `classpath:` prefix are supported, skipping unsupported resource location: {}", location);
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            List<Resource> resources = ClasspathResourceUtils.findResources(normalizedLocations);
            logger.info("Paths {} and resources {}", normalizedLocations, resources);
            if (!resources.isEmpty()) {
                DeployResourceCommandStep1 deployResourceCommand = this.client.newDeployResourceCommand();
                DeployResourceCommandStep1.DeployResourceCommandStep2 finalCommand = null;
                Iterator<Resource> iterator = resources.iterator();
                while (iterator.hasNext()) {
                    Resource resource;
                    Resource res = resource = iterator.next();
                    try {
                        InputStream is = res.asInputStream();
                        try {
                            finalCommand = deployResourceCommand.addResourceStream(is, resource.name());
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                    finally {
                        if (res == null) continue;
                        res.close();
                    }
                }
                if (finalCommand != null) {
                    DeploymentEvent deploymentEvent = (DeploymentEvent)finalCommand.send().get(this.deploymentConfig.timeout().toMillis(), TimeUnit.MILLISECONDS);
                    List<String> deployments = Stream.concat(deploymentEvent.getDecisionRequirements().stream().map(req -> String.format("Decision:<%s:%d>", req.getDmnDecisionRequirementsId(), req.getVersion())), deploymentEvent.getProcesses().stream().map(process -> String.format("Process:<%s:%d>", process.getBpmnProcessId(), process.getVersion()))).toList();
                    logger.info("Zeebe resources {} deployed in {}", deployments, (Object)TimeUtils.tookForLogging((long)started));
                }
            } else {
                logger.debug("Zeebe no resources found for deployment in {}", locations);
            }
        }
    }

    public void release() {
    }

    static final class ClasspathResourceUtils {
        private ClasspathResourceUtils() {
        }

        public static Optional<Resource> findResource(String path) {
            return ClasspathResourceUtils.findResources(path).stream().findFirst();
        }

        public static List<Resource> findResources(Collection<String> paths) {
            return paths.stream().distinct().flatMap(p -> ClasspathResourceUtils.findResources(p).stream()).distinct().toList();
        }

        public static List<Resource> findResources(String path) {
            Pattern pattern;
            List<URL> pathResources;
            String workPath;
            if (path == null || path.isBlank()) {
                return Collections.emptyList();
            }
            if (path.startsWith("./")) {
                return ClasspathResourceUtils.findResources(path.substring(2));
            }
            if (path.startsWith("/")) {
                return ClasspathResourceUtils.findResources(path.substring(1));
            }
            int innerDirectoryFrom = path.lastIndexOf(47);
            if (innerDirectoryFrom == -1) {
                List<URL> directoryOnlyResources = ClasspathResourceUtils.getSystemResources(path);
                if (!directoryOnlyResources.isEmpty()) {
                    workPath = path;
                    pathResources = directoryOnlyResources;
                    pattern = null;
                } else {
                    workPath = ".";
                    pathResources = ClasspathResourceUtils.getSystemResources(workPath);
                    pattern = Pattern.compile("^" + path);
                }
            } else {
                workPath = path.substring(0, innerDirectoryFrom);
                pathResources = ClasspathResourceUtils.getSystemResources(workPath);
                pattern = Pattern.compile("^" + path.substring(innerDirectoryFrom + 1));
            }
            return pathResources.stream().map(r -> {
                if (r.toString().startsWith("jar")) {
                    return ClasspathResourceUtils.loadFromJar(workPath, r, pattern);
                }
                return ClasspathResourceUtils.loadFromDirectory(workPath, r, pattern);
            }).flatMap(Collection::stream).toList();
        }

        private static List<Resource> loadFromDirectory(String path, URL resource, @Nullable Pattern pattern) {
            File filePath = new File(resource.getPath());
            if (filePath.isFile()) {
                if (pattern == null) {
                    return List.of(new FileResource(filePath.getName(), "."));
                }
                if (pattern.matcher(filePath.getName()).matches()) {
                    return List.of(new FileResource(filePath.getName(), path));
                }
                return List.of();
            }
            ArrayList<Resource> resources = new ArrayList<Resource>();
            String[] files = filePath.list();
            if (files == null || files.length == 0) {
                return Collections.emptyList();
            }
            for (String fileName : files) {
                File file = new File(filePath, fileName);
                if (!file.isFile()) continue;
                if (pattern == null) {
                    resources.add(new FileResource(file.getName(), path));
                    continue;
                }
                if (!pattern.matcher(fileName).matches()) continue;
                resources.add(new FileResource(file.getName(), path));
            }
            return resources;
        }

        private static List<Resource> loadFromJar(String path, URL resource, @Nullable Pattern pattern) {
            String jarPath = resource.getPath().replaceFirst("[.]jar!.*", ".jar").replaceFirst("[.]tar!.*", ".tar").replaceFirst("file:", "");
            try {
                String jarUrlPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8);
                logger.info("JarPath {}, path {}, pattern {}", new Object[]{jarPath, path, pattern});
                JarFile jar = new JarFile(jarUrlPath);
                ArrayList<Resource> classes = new ArrayList<Resource>();
                Enumeration<JarEntry> files = jar.entries();
                AtomicInteger closeCounter = new AtomicInteger(0);
                while (files.hasMoreElements()) {
                    JarEntry file = files.nextElement();
                    if (file.isDirectory()) continue;
                    String fileFullName = file.getName();
                    String fileName = fileFullName.lastIndexOf(47) == -1 ? fileFullName : fileFullName.substring(fileFullName.lastIndexOf(47) + 1);
                    logger.info("File {}, path {}, pattern {}", new Object[]{fileFullName, path, pattern});
                    if ((pattern != null || !fileFullName.startsWith(path)) && (pattern == null || !pattern.matcher(fileName).matches())) continue;
                    logger.info("Match pattern {}, fileName {}", (Object)pattern, (Object)fileName);
                    closeCounter.incrementAndGet();
                    classes.add(new JarResource(fileFullName, jarUrlPath, () -> {
                        try {
                            return jar.getInputStream(file);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e.getMessage() + " for file: " + jarPath, e);
                        }
                    }, () -> {
                        int res = closeCounter.decrementAndGet();
                        if (res < 1) {
                            jar.close();
                        }
                    }));
                }
                return classes;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't open Jar '" + jarPath, e);
            }
        }

        private static List<URL> getSystemResources(String path) {
            try {
                Enumeration<URL> resourceUrls = ClasspathResourceUtils.class.getClassLoader().getResources(path);
                if (!resourceUrls.hasMoreElements()) {
                    return Collections.emptyList();
                }
                ArrayList<URL> resources = new ArrayList<URL>();
                while (resourceUrls.hasMoreElements()) {
                    URL url = resourceUrls.nextElement();
                    resources.add(url);
                }
                return resources;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    static interface Resource
    extends Closeable {
        public String name();

        public String path();

        public InputStream asInputStream();
    }

    record FileResource(String name, String path) implements Resource
    {
        @Override
        public InputStream asInputStream() {
            return FileResource.class.getResourceAsStream("/" + this.path + "/" + this.name);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Resource)) {
                return false;
            }
            Resource that = (Resource)object;
            return Objects.equals(this.name, that.name()) && Objects.equals(this.path, that.path());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.path);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    record JarResource(String name, String path, Supplier<InputStream> inputStream, @Nullable Closeable closeable) implements Resource
    {
        public JarResource(String name, String path, Supplier<InputStream> inputStream) {
            this(name, path, inputStream, null);
        }

        @Override
        public InputStream asInputStream() {
            return this.inputStream.get();
        }

        @Override
        public void close() throws IOException {
            if (this.closeable != null) {
                this.closeable.close();
            }
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Resource)) {
                return false;
            }
            Resource that = (Resource)object;
            return Objects.equals(this.name, that.name()) && Objects.equals(this.path, that.path());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.path);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

