/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker.telemetry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.camunda.zeebe.worker.JobContext;
import ru.tinkoff.kora.camunda.zeebe.worker.JobWorkerException;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerLogger;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerTelemetry;

public final class DefaultZeebeWorkerLogger
implements ZeebeWorkerLogger {
    private final Logger logger = LoggerFactory.getLogger(ZeebeWorkerLogger.class);

    @Override
    public void logStarted(JobContext context) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Zeebe JobWorker started Job {} with variables {}", (Object)context, (Object)context.variablesAsString());
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Zeebe JobWorker started Job {}", (Object)context);
        }
    }

    @Override
    public void logComplete(JobContext context) {
        this.logger.info("Zeebe JobWorker completed Job {}", (Object)context);
    }

    @Override
    public void logFailed(JobContext context, ZeebeWorkerTelemetry.ErrorType errorType, Throwable throwable) {
        if (throwable instanceof JobWorkerException) {
            JobWorkerException je = (JobWorkerException)throwable;
            this.logger.warn("Zeebe JobWorker failed Job {} with code {} and message {}", new Object[]{context, je.getCode(), je.getMessage()});
        } else {
            this.logger.warn("Zeebe JobWorker failed Job {} with message {}", (Object)context, (Object)throwable.getMessage());
        }
    }
}

