/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.camunda.zeebe.worker.JobContext;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.DefaultZeebeWorkerTelemetry;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerLogger;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerLoggerFactory;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerMetrics;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerMetricsFactory;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerTelemetry;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerTelemetryFactory;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerTracer;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerTracerFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class DefaultZeebeWorkerTelemetryFactory
implements ZeebeWorkerTelemetryFactory {
    private static final ZeebeWorkerTelemetry EMPTY = new NoopZeebeWorkerTelemetry();
    private final ZeebeWorkerLoggerFactory loggerFactory;
    private final ZeebeWorkerMetricsFactory metricsFactory;
    private final ZeebeWorkerTracerFactory tracerFactory;

    public DefaultZeebeWorkerTelemetryFactory(@Nullable ZeebeWorkerLoggerFactory loggerFactory, @Nullable ZeebeWorkerMetricsFactory metricsFactory, @Nullable ZeebeWorkerTracerFactory tracerFactory) {
        this.loggerFactory = loggerFactory;
        this.metricsFactory = metricsFactory;
        this.tracerFactory = tracerFactory;
    }

    @Override
    public ZeebeWorkerTelemetry get(String workerType, TelemetryConfig config) {
        ZeebeWorkerTracer tracer;
        ZeebeWorkerLogger logger = this.loggerFactory == null ? null : this.loggerFactory.get(config.logging());
        ZeebeWorkerMetrics metrics = this.metricsFactory == null ? null : this.metricsFactory.get(config.metrics());
        ZeebeWorkerTracer zeebeWorkerTracer = tracer = this.tracerFactory == null ? null : this.tracerFactory.get(config.tracing());
        if (metrics == null && tracer == null && logger == null) {
            return EMPTY;
        }
        return new DefaultZeebeWorkerTelemetry(workerType, logger, metrics, tracer);
    }

    private static final class NoopZeebeWorkerTelemetry
    implements ZeebeWorkerTelemetry {
        private static final ZeebeWorkerTelemetry.ZeebeWorkerTelemetryContext EMPTY = new NoopZeebeWorkerTelemetryContext();

        private NoopZeebeWorkerTelemetry() {
        }

        @Override
        public ZeebeWorkerTelemetry.ZeebeWorkerTelemetryContext get(JobContext jobContext) {
            return EMPTY;
        }

        private static final class NoopZeebeWorkerTelemetryContext
        implements ZeebeWorkerTelemetry.ZeebeWorkerTelemetryContext {
            private NoopZeebeWorkerTelemetryContext() {
            }

            @Override
            public void close() {
            }

            @Override
            public void close(ZeebeWorkerTelemetry.ErrorType errorType, Throwable throwable) {
            }
        }
    }
}

