/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.camunda.zeebe.worker.JobContext;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerLogger;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerMetrics;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerTelemetry;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerTracer;

public final class DefaultZeebeWorkerTelemetry
implements ZeebeWorkerTelemetry {
    private final String workerType;
    private final ZeebeWorkerLogger logger;
    private final ZeebeWorkerMetrics metrics;
    private final ZeebeWorkerTracer tracer;

    public DefaultZeebeWorkerTelemetry(String workerType, @Nullable ZeebeWorkerLogger logger, @Nullable ZeebeWorkerMetrics metrics, @Nullable ZeebeWorkerTracer tracer) {
        this.workerType = workerType;
        this.logger = logger;
        this.metrics = metrics;
        this.tracer = tracer;
    }

    @Override
    public ZeebeWorkerTelemetry.ZeebeWorkerTelemetryContext get(final JobContext jobContext) {
        final long startTime = System.nanoTime();
        if (this.logger != null) {
            this.logger.logStarted(jobContext);
        }
        final ZeebeWorkerTracer.ZeebeWorkerSpan span = this.tracer != null ? this.tracer.createSpan(this.workerType, jobContext) : null;
        return new ZeebeWorkerTelemetry.ZeebeWorkerTelemetryContext(){

            @Override
            public void close() {
                if (DefaultZeebeWorkerTelemetry.this.logger != null) {
                    DefaultZeebeWorkerTelemetry.this.logger.logComplete(jobContext);
                }
                if (DefaultZeebeWorkerTelemetry.this.metrics != null) {
                    long end = System.nanoTime();
                    long processingTime = end - startTime;
                    DefaultZeebeWorkerTelemetry.this.metrics.recordComplete(jobContext, processingTime);
                }
                if (span != null) {
                    span.close();
                }
            }

            @Override
            public void close(ZeebeWorkerTelemetry.ErrorType errorType, Throwable throwable) {
                if (DefaultZeebeWorkerTelemetry.this.logger != null) {
                    DefaultZeebeWorkerTelemetry.this.logger.logFailed(jobContext, errorType, throwable);
                }
                if (DefaultZeebeWorkerTelemetry.this.metrics != null) {
                    long end = System.nanoTime();
                    long processingTime = end - startTime;
                    DefaultZeebeWorkerTelemetry.this.metrics.recordFailed(jobContext, processingTime, errorType, throwable);
                }
                if (span != null) {
                    span.close(errorType, throwable);
                }
            }
        };
    }
}

