/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import io.camunda.zeebe.client.api.response.ActivatedJob;
import java.time.Instant;
import java.util.Map;
import ru.tinkoff.kora.camunda.zeebe.worker.JobContext;

public record ActiveJobContext(String name, ActivatedJob job) implements JobContext
{
    @Override
    public long jobKey() {
        return this.job.getKey();
    }

    @Override
    public String jobName() {
        return this.name;
    }

    @Override
    public String jobType() {
        return this.job.getType();
    }

    @Override
    public String jobWorker() {
        return this.job.getWorker();
    }

    @Override
    public String tenantId() {
        return this.job.getTenantId();
    }

    @Override
    public long processInstanceKey() {
        return this.job.getProcessInstanceKey();
    }

    @Override
    public String processId() {
        return this.job.getBpmnProcessId();
    }

    @Override
    public int processDefinitionVersion() {
        return this.job.getProcessDefinitionVersion();
    }

    @Override
    public long processDefinitionKey() {
        return this.job.getProcessDefinitionKey();
    }

    @Override
    public String elementId() {
        return this.job.getElementId();
    }

    @Override
    public long elementInstanceKey() {
        return this.job.getElementInstanceKey();
    }

    @Override
    public Map<String, String> headers() {
        return this.job.getCustomHeaders();
    }

    @Override
    public int retryCount() {
        return this.job.getRetries();
    }

    @Override
    public Instant deadline() {
        return Instant.ofEpochMilli(this.job.getDeadline());
    }

    @Override
    public long deadlineAsMillis() {
        return this.job.getDeadline();
    }

    @Override
    public String variablesAsString() {
        return this.job.getVariables();
    }

    @Override
    public String toString() {
        return "[jobName=" + this.jobName() + ", jobType=" + this.jobType() + ", jobKey=" + this.jobKey() + ", processId=" + this.processId() + ", elementId=" + this.elementId() + "]";
    }
}

