/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import ru.tinkoff.kora.common.util.Size;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@ConfigValueExtractor
public interface ZeebeClientConfig {
    default public int executionThreads() {
        return Math.max(Runtime.getRuntime().availableProcessors(), 2);
    }

    default public boolean tls() {
        return true;
    }

    default public Duration keepAlive() {
        return Duration.ofSeconds(45L);
    }

    @Nullable
    public String certificatePath();

    @Nullable
    public Duration initializationFailTimeout();

    public GrpcConfig grpc();

    @Nullable
    public RestConfig rest();

    public DeploymentConfig deployment();

    public TelemetryConfig telemetry();

    @ConfigValueExtractor
    public static interface DeploymentConfig {
        default public Duration timeout() {
            return Duration.ofSeconds(45L);
        }

        default public List<String> resources() {
            return Collections.emptyList();
        }
    }

    @ConfigValueExtractor
    public static interface GrpcRetryConfig {
        default public boolean enabled() {
            return true;
        }

        default public int attempts() {
            return 5;
        }

        default public Duration delay() {
            return Duration.ofMillis(100L);
        }

        default public Duration delayMax() {
            return Duration.ofSeconds(5L);
        }

        default public Double step() {
            return 3.0;
        }
    }

    @ConfigValueExtractor
    public static interface GrpcConfig {
        public String url();

        default public Duration ttl() {
            return Duration.ofHours(1L);
        }

        default public Size maxMessageSize() {
            return Size.of((long)4L, (Size.Type)Size.Type.MiB);
        }

        public GrpcRetryConfig retryPolicy();
    }

    @ConfigValueExtractor
    public static interface RestConfig {
        public String url();
    }
}

