/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.camunda.zeebe.worker.ZeebeClientConfig;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.common.util.Size;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $ZeebeClientConfig_GrpcConfig_ConfigValueExtractor
implements ConfigValueExtractor<ZeebeClientConfig.GrpcConfig> {
    public static final GrpcConfig_Defaults DEFAULTS = new GrpcConfig_Defaults();
    private static final PathElement.Key _url_path = PathElement.get((String)"url");
    private static final PathElement.Key _ttl_path = PathElement.get((String)"ttl");
    private static final PathElement.Key _maxMessageSize_path = PathElement.get((String)"maxMessageSize");
    private static final PathElement.Key _retryPolicy_path = PathElement.get((String)"retryPolicy");
    private final ConfigValueExtractor<Duration> ttl_parser;
    private final ConfigValueExtractor<Size> maxMessageSize_parser;
    private final ConfigValueExtractor<ZeebeClientConfig.GrpcRetryConfig> retryPolicy_parser;

    public $ZeebeClientConfig_GrpcConfig_ConfigValueExtractor(ConfigValueExtractor<Duration> extractor1, ConfigValueExtractor<Size> extractor2, ConfigValueExtractor<ZeebeClientConfig.GrpcRetryConfig> extractor3) {
        this.ttl_parser = extractor1;
        this.maxMessageSize_parser = extractor2;
        this.retryPolicy_parser = extractor3;
    }

    public ZeebeClientConfig.GrpcConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        String url = this.parse_url(_config);
        Duration ttl = this.parse_ttl(_config);
        Size maxMessageSize = this.parse_maxMessageSize(_config);
        ZeebeClientConfig.GrpcRetryConfig retryPolicy = this.parse_retryPolicy(_config);
        return new GrpcConfig_Impl(url, ttl, maxMessageSize, retryPolicy);
    }

    private String parse_url(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_url_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private Duration parse_ttl(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_ttl_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.ttl();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.ttl_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Size parse_maxMessageSize(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_maxMessageSize_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Size defaultValue = DEFAULTS.maxMessageSize();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Size parsed = (Size)this.maxMessageSize_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private ZeebeClientConfig.GrpcRetryConfig parse_retryPolicy(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_retryPolicy_path);
        ZeebeClientConfig.GrpcRetryConfig parsed = (ZeebeClientConfig.GrpcRetryConfig)this.retryPolicy_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public record GrpcConfig_Impl(@Nonnull String url, @Nonnull Duration ttl, @Nonnull Size maxMessageSize, @Nonnull ZeebeClientConfig.GrpcRetryConfig retryPolicy) implements ZeebeClientConfig.GrpcConfig
    {
        public GrpcConfig_Impl {
            Objects.requireNonNull(url);
            Objects.requireNonNull(ttl);
            Objects.requireNonNull(maxMessageSize);
            Objects.requireNonNull(retryPolicy);
        }
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public static final class GrpcConfig_Defaults
    implements ZeebeClientConfig.GrpcConfig {
        @Override
        public String url() {
            return null;
        }

        @Override
        public ZeebeClientConfig.GrpcRetryConfig retryPolicy() {
            return null;
        }
    }
}

