/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.response.Topology;
import io.camunda.zeebe.client.impl.ZeebeClientImpl;
import io.grpc.ManagedChannel;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.camunda.zeebe.worker.ZeebeClientConfig;
import ru.tinkoff.kora.common.util.TimeUtils;

public final class KoraZeebeClient
implements Wrapped<ZeebeClient>,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(KoraZeebeClient.class);
    private final ZeebeClientConfig clientConfig;
    private final ZeebeClientConfiguration clientConfiguration;
    private final ManagedChannel managedChannel;
    private volatile ZeebeClientImpl zeebeClient;

    public KoraZeebeClient(ZeebeClientConfig clientConfig, ZeebeClientConfiguration clientConfiguration, ManagedChannel managedChannel) {
        this.clientConfig = clientConfig;
        this.clientConfiguration = clientConfiguration;
        this.managedChannel = managedChannel;
    }

    public ZeebeClient value() {
        return this.zeebeClient;
    }

    public void init() {
        logger.debug("ZeebeClient starting...");
        long started = TimeUtils.started();
        this.zeebeClient = new ZeebeClientImpl(this.clientConfiguration, this.managedChannel);
        Duration initTimeout = this.clientConfig.initializationFailTimeout();
        if (initTimeout != null) {
            try {
                Topology topology = (Topology)this.zeebeClient.newTopologyRequest().send().join(initTimeout.toMillis(), TimeUnit.MILLISECONDS);
                if (topology.getBrokers().isEmpty()) {
                    throw new IllegalStateException("ZeebeClient is unavailable for gRPC URL: " + String.valueOf(this.clientConfiguration.getGrpcAddress()));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("ZeebeClient initialization failed after timeout " + String.valueOf(initTimeout) + " for gRPC URL: " + String.valueOf(this.clientConfiguration.getGrpcAddress()));
            }
        }
        logger.info("ZeebeClient started in {}", (Object)TimeUtils.tookForLogging((long)started));
    }

    public void release() {
        if (this.zeebeClient != null) {
            logger.debug("ZeebeClient stopping...");
            long started = TimeUtils.started();
            this.zeebeClient.close();
            logger.info("ZeebeClient stopped in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
    }
}

