/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import ru.tinkoff.kora.camunda.zeebe.worker.;
import ru.tinkoff.kora.camunda.zeebe.worker.$ZeebeWorkerConfig_BackoffConfig_ConfigValueExtractor;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;

@ConfigValueExtractor
public interface ZeebeWorkerConfig {
    public static final String DEFAULT = "default";
    public static final BackoffConfig DEFAULT_BACKOFF_CONFIG = new $ZeebeWorkerConfig_BackoffConfig_ConfigValueExtractor.BackoffConfig_Impl(Duration.ofMillis(500L), Duration.ofMillis(100L), 1.0, 1.1);
    public static final JobConfig DEFAULT_JOB_CONFIG = new .ZeebeWorkerConfig_JobConfig_ConfigValueExtractor.JobConfig_Impl("default", DEFAULT_BACKOFF_CONFIG, List.of(), Duration.ofMinutes(15L), 32, Duration.ofSeconds(15L), Duration.ofMillis(100L), true, false, Duration.ofSeconds(15L));

    default public Map<String, JobConfig> job() {
        return Map.of();
    }

    default public JobConfig getJobConfig(@Nonnull String jobType) {
        JobConfig defaultConfig = this.job().get(DEFAULT);
        defaultConfig = defaultConfig == null ? DEFAULT_JOB_CONFIG : ZeebeWorkerConfig.merge(defaultConfig, DEFAULT_JOB_CONFIG);
        JobConfig jobConfig = this.job().get(jobType);
        if (jobConfig == null) {
            return defaultConfig;
        }
        return ZeebeWorkerConfig.merge(jobConfig, defaultConfig);
    }

    private static JobConfig merge(@Nullable JobConfig targetConfig, JobConfig defaultConfig) {
        if (targetConfig == null) {
            return defaultConfig;
        }
        BackoffConfig backoff = ZeebeWorkerConfig.merge(targetConfig.backoff(), defaultConfig.backoff());
        return new .ZeebeWorkerConfig_JobConfig_ConfigValueExtractor.JobConfig_Impl(targetConfig.name() == null ? defaultConfig.name() : targetConfig.name(), backoff, targetConfig.tenantIds() == null ? defaultConfig.tenantIds() : targetConfig.tenantIds(), targetConfig.timeout() == null ? defaultConfig.timeout() : targetConfig.timeout(), targetConfig.maxJobsActive() == null ? defaultConfig.maxJobsActive() : targetConfig.maxJobsActive(), targetConfig.requestTimeout() == null ? defaultConfig.requestTimeout() : targetConfig.requestTimeout(), targetConfig.pollInterval() == null ? defaultConfig.pollInterval() : targetConfig.pollInterval(), targetConfig.enabled() == null ? defaultConfig.enabled() : targetConfig.enabled(), targetConfig.streamEnabled() == null ? defaultConfig.streamEnabled() : targetConfig.streamEnabled(), targetConfig.streamTimeout() == null ? defaultConfig.streamTimeout() : targetConfig.streamTimeout());
    }

    private static BackoffConfig merge(@Nullable BackoffConfig targetConfig, BackoffConfig defaultConfig) {
        if (targetConfig == null) {
            return defaultConfig;
        }
        return new $ZeebeWorkerConfig_BackoffConfig_ConfigValueExtractor.BackoffConfig_Impl(targetConfig.maxDelay() == null ? defaultConfig.maxDelay() : targetConfig.maxDelay(), targetConfig.minDelay() == null ? defaultConfig.minDelay() : targetConfig.minDelay(), targetConfig.factor() == null ? defaultConfig.factor() : targetConfig.factor(), targetConfig.jitter() == null ? defaultConfig.jitter() : targetConfig.jitter());
    }

    @ConfigValueExtractor
    public static interface JobConfig {
        default public String name() {
            return ZeebeWorkerConfig.DEFAULT;
        }

        @Nullable
        public BackoffConfig backoff();

        @Nullable
        public List<String> tenantIds();

        @Nullable
        public Duration timeout();

        @Nullable
        public Integer maxJobsActive();

        @Nullable
        public Duration requestTimeout();

        @Nullable
        public Duration pollInterval();

        @Nullable
        public Boolean enabled();

        @Nullable
        public Boolean streamEnabled();

        @Nullable
        public Duration streamTimeout();
    }

    @ConfigValueExtractor
    public static interface BackoffConfig {
        @Nullable
        public Duration maxDelay();

        @Nullable
        public Duration minDelay();

        @Nullable
        public Double factor();

        @Nullable
        public Double jitter();
    }
}

