/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import io.camunda.zeebe.client.api.command.FailJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import java.util.concurrent.CompletionException;
import ru.tinkoff.kora.camunda.zeebe.worker.ActiveJobContext;
import ru.tinkoff.kora.camunda.zeebe.worker.JobWorkerException;
import ru.tinkoff.kora.camunda.zeebe.worker.KoraJobWorker;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerTelemetry;

final class WrappedJobHandler
implements JobHandler {
    private final ZeebeWorkerTelemetry telemetry;
    private final KoraJobWorker jobHandler;

    public WrappedJobHandler(ZeebeWorkerTelemetry telemetry, KoraJobWorker jobHandler) {
        this.telemetry = telemetry;
        this.jobHandler = jobHandler;
    }

    public void handle(JobClient client, ActivatedJob job) {
        ActiveJobContext jobContext = new ActiveJobContext(this.jobHandler.type(), job);
        ZeebeWorkerTelemetry.ZeebeWorkerTelemetryContext telemetryContext = this.telemetry.get(jobContext);
        try {
            this.jobHandler.handle(client, job).whenComplete((command, ex) -> {
                if (command != null) {
                    this.handlerSuccess(telemetryContext, (FinalCommandStep<?>)command);
                } else {
                    this.handleError(client, job, telemetryContext, (Throwable)ex);
                }
            });
        }
        catch (Exception e) {
            this.handleError(client, job, telemetryContext, e);
        }
    }

    private void handlerSuccess(ZeebeWorkerTelemetry.ZeebeWorkerTelemetryContext telemetryContext, FinalCommandStep<?> command) {
        command.send().whenComplete((r, e) -> {
            if (e != null) {
                telemetryContext.close(ZeebeWorkerTelemetry.ErrorType.SYSTEM, (Throwable)e);
            } else if (command instanceof ThrowErrorCommandStep1.ThrowErrorCommandStep2 || command instanceof FailJobCommandStep1.FailJobCommandStep2) {
                telemetryContext.close(ZeebeWorkerTelemetry.ErrorType.USER, null);
            } else {
                telemetryContext.close();
            }
        });
    }

    private void handleError(JobClient client, ActivatedJob job, ZeebeWorkerTelemetry.ZeebeWorkerTelemetryContext telemetryContext, Throwable e) {
        JobWorkerException ex2;
        Throwable cause = e instanceof CompletionException ? e.getCause() : e;
        JobWorkerException je = cause instanceof JobWorkerException ? (ex2 = (JobWorkerException)cause) : new JobWorkerException("INTERNAL", cause);
        FinalCommandStep<Void> command = this.createErrorCommand(client, job, je);
        command.send().whenComplete((r, ex) -> {
            if (ex != null) {
                telemetryContext.close(ZeebeWorkerTelemetry.ErrorType.SYSTEM, je);
            } else {
                telemetryContext.close(ZeebeWorkerTelemetry.ErrorType.USER, je);
            }
        });
    }

    private FinalCommandStep<Void> createErrorCommand(JobClient client, ActivatedJob job, JobWorkerException exception) {
        ThrowErrorCommandStep1.ThrowErrorCommandStep2 command = client.newThrowErrorCommand(job.getKey()).errorCode(exception.getCode()).errorMessage(exception.getMessage());
        if (exception.getVariables() != null) {
            command.variables(exception.getVariables());
        }
        return command;
    }
}

