/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ServiceDescriptor;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.grpc.client.GrpcClientChannelFactory;
import ru.tinkoff.grpc.client.config.GrpcClientConfig;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetry;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetryFactory;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetryInterceptor;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.util.TimeUtils;

final class ZeebeManagedChannelLifecycle
implements Lifecycle,
Wrapped<ManagedChannel> {
    private static final Logger logger = LoggerFactory.getLogger(ZeebeManagedChannelLifecycle.class);
    private final GrpcClientConfig config;
    private final ServiceDescriptor serviceDefinition;
    private final GrpcClientChannelFactory channelFactory;
    private final ChannelCredentials channelCredentials;
    private final GrpcClientTelemetryFactory telemetryFactory;
    private final List<ClientInterceptor> interceptors;
    private volatile ManagedChannel channel;

    public ZeebeManagedChannelLifecycle(GrpcClientConfig config, @Nullable ChannelCredentials channelCredentials, List<ClientInterceptor> interceptors, GrpcClientTelemetryFactory telemetryFactory, GrpcClientChannelFactory channelFactory, ServiceDescriptor serviceDefinition) {
        this.config = config;
        this.serviceDefinition = serviceDefinition;
        this.channelCredentials = channelCredentials;
        this.channelFactory = channelFactory;
        this.telemetryFactory = telemetryFactory;
        this.interceptors = interceptors;
    }

    public void init() {
        ManagedChannelBuilder builder;
        logger.debug("Zeebe GrpcManagedChannel starting...");
        long started = TimeUtils.started();
        URI uri = URI.create(this.config.url());
        String host = uri.getHost();
        int port = uri.getPort();
        String scheme = uri.getScheme();
        if (port < 0) {
            if (Objects.equals(scheme, "http")) {
                port = 80;
            } else if (Objects.equals(scheme, "https")) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Unknown scheme '" + scheme + "'");
            }
        }
        ManagedChannelBuilder managedChannelBuilder = builder = this.channelCredentials == null ? this.channelFactory.forAddress(host, port) : this.channelFactory.forAddress(host, port, this.channelCredentials);
        if (Objects.equals(scheme, "http")) {
            builder.usePlaintext();
        }
        ArrayList<Object> interceptors = new ArrayList<Object>(2);
        GrpcClientTelemetry telemetry = this.telemetryFactory.get(this.serviceDefinition, this.config.telemetry(), uri);
        if (telemetry != null) {
            interceptors.add(new GrpcClientTelemetryInterceptor(telemetry));
        }
        interceptors.addAll(this.interceptors);
        builder.intercept(interceptors);
        this.channel = builder.build();
        logger.info("Zeebe GrpcManagedChannel started in {}", (Object)TimeUtils.tookForLogging((long)started));
    }

    public void release() {
        if (this.channel != null) {
            logger.debug("Zeebe GrpcManagedChannel closing...");
            long started = TimeUtils.started();
            this.channel.shutdown();
            this.channel = null;
            logger.info("Zeebe GrpcManagedChannel started in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public ManagedChannel value() {
        return this.channel;
    }
}

