/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.zeebe.worker;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import jakarta.annotation.Nullable;
import java.io.IOException;
import ru.tinkoff.kora.json.common.JsonReader;

public final class ZeebeVariableJsonReader<T>
implements JsonReader<T> {
    private final SerializedString fetchVariableName;
    private final boolean isNullable;
    private final JsonReader<T> valueReader;

    public ZeebeVariableJsonReader(String fetchVariableName, boolean isNullable, JsonReader<T> valueReader) {
        this.isNullable = isNullable;
        this.valueReader = valueReader;
        this.fetchVariableName = new SerializedString(fetchVariableName);
    }

    private T readValue(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        if (token == JsonToken.VALUE_NULL) {
            if (this.isNullable) {
                return null;
            }
            throw new JsonParseException(parser, "Expecting NonNull value for Fetch Variable '" + String.valueOf(this.fetchVariableName) + "', but got VALUE_NULL token");
        }
        return (T)this.valueReader.read(parser);
    }

    @Nullable
    public T read(JsonParser parser) throws IOException {
        JsonToken token = parser.currentToken();
        if (token == JsonToken.VALUE_NULL) {
            if (this.isNullable) {
                return null;
            }
            throw new JsonParseException(parser, "Expecting NonNull value for Fetch Variable '" + String.valueOf(this.fetchVariableName) + "', but got NULLABLE fetch variables");
        }
        if (token != JsonToken.START_OBJECT) {
            throw new JsonParseException(parser, "Expecting START_OBJECT token, got " + String.valueOf(token));
        }
        T value = null;
        if (parser.nextFieldName((SerializableString)this.fetchVariableName)) {
            value = this.readValue(parser);
            return value;
        }
        token = parser.currentToken();
        while (token != JsonToken.END_OBJECT) {
            String fieldName;
            if (token == JsonToken.FIELD_NAME && (fieldName = parser.currentName()).equals(this.fetchVariableName.getValue())) {
                value = this.readValue(parser);
                break;
            }
            parser.nextToken();
            parser.skipChildren();
            token = parser.nextToken();
        }
        if (value == null && !this.isNullable) {
            throw new JsonParseException(parser, "Expecting NonNull value for Fetch Variable '" + String.valueOf(this.fetchVariableName) + "', but got NULLABLE fetch variable");
        }
        return value;
    }
}

