/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.s3.client.aws;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import org.jetbrains.annotations.ApiStatus;
import ru.tinkoff.kora.s3.client.model.S3Body;

@ApiStatus.Experimental
final class AwsS3BodyAsync
implements S3Body {
    private final String encoding;
    private final String type;
    private final long size;
    private final Flow.Publisher<ByteBuffer> publisher;

    public AwsS3BodyAsync(String encoding, String type, long size, Flow.Publisher<ByteBuffer> publisher) {
        this.encoding = encoding;
        this.type = type;
        this.size = size;
        this.publisher = publisher;
    }

    public InputStream asInputStream() {
        return S3Body.ofPublisher(this.publisher, (long)this.size, (String)this.type, (String)this.encoding).asInputStream();
    }

    public Flow.Publisher<ByteBuffer> asPublisher() {
        return this.publisher;
    }

    public long size() {
        return this.size;
    }

    public String encoding() {
        return this.encoding;
    }

    public String type() {
        return this.type;
    }

    public String toString() {
        return "AwsS3Body{type=" + this.type + ", encoding=" + this.encoding + ", size=" + this.size + "}";
    }
}

