/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.s3.client.aws;

import java.time.Instant;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import ru.tinkoff.kora.s3.client.model.S3ObjectMeta;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Object;

@ApiStatus.Experimental
final class AwsS3ObjectMeta
implements S3ObjectMeta {
    private final String key;
    private final Instant modified;
    private final long size;

    public AwsS3ObjectMeta(String key, GetObjectResponse response) {
        this.key = key;
        this.modified = response.lastModified();
        this.size = response.contentLength();
    }

    public AwsS3ObjectMeta(String key, GetObjectAttributesResponse response) {
        this.key = key;
        this.modified = response.lastModified();
        this.size = response.objectSize();
    }

    public AwsS3ObjectMeta(S3Object object) {
        this.key = object.key();
        this.modified = object.lastModified();
        this.size = object.size();
    }

    public String key() {
        return this.key;
    }

    public Instant modified() {
        return this.modified;
    }

    public long size() {
        return this.size;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AwsS3ObjectMeta meta = (AwsS3ObjectMeta)object;
        return this.size == meta.size && Objects.equals(this.key, meta.key);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.size);
    }

    public String toString() {
        return "AwsS3ObjectMeta{key=" + this.key + ", size=" + this.size + ", modified=" + String.valueOf(this.modified) + "}";
    }
}

