/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.s3.client.aws;

import java.io.InputStream;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import org.jetbrains.annotations.ApiStatus;
import ru.tinkoff.kora.s3.client.model.S3Body;

@ApiStatus.Experimental
final class AwsS3BodySync
implements S3Body {
    private final String encoding;
    private final String type;
    private final long size;
    private final InputStream inputStream;

    public AwsS3BodySync(String encoding, String type, long size, InputStream inputStream) {
        this.encoding = encoding;
        this.type = type;
        this.size = size;
        this.inputStream = inputStream;
    }

    public InputStream asInputStream() {
        return this.inputStream;
    }

    public Flow.Publisher<ByteBuffer> asPublisher() {
        return HttpRequest.BodyPublishers.ofInputStream(() -> this.inputStream);
    }

    public long size() {
        return this.size;
    }

    public String encoding() {
        return this.encoding;
    }

    public String type() {
        return this.type;
    }

    public String toString() {
        return "AwsS3Body{type=" + this.type + ", encoding=" + this.encoding + ", size=" + this.size + "}";
    }
}

