/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.s3.client.aws;

import java.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import ru.tinkoff.kora.common.util.Size;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;

@ConfigValueExtractor
@ApiStatus.Experimental
public interface AwsS3ClientConfig {
    default public AddressStyle addressStyle() {
        return AddressStyle.PATH;
    }

    default public Duration requestTimeout() {
        return Duration.ofSeconds(45L);
    }

    default public boolean checksumValidationEnabled() {
        return false;
    }

    default public boolean chunkedEncodingEnabled() {
        return true;
    }

    public UploadConfig upload();

    public static enum AddressStyle {
        PATH,
        VIRTUAL_HOSTED;

    }

    @ConfigValueExtractor
    public static interface UploadConfig {
        default public Size bufferSize() {
            return Size.of((long)32L, (Size.Type)Size.Type.MiB);
        }

        default public Size partSize() {
            return Size.of((long)8L, (Size.Type)Size.Type.MiB);
        }
    }
}

