/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.s3.client.aws;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.kora.s3.client.S3Exception;
import ru.tinkoff.kora.s3.client.aws.AwsS3ClientConfig;
import ru.tinkoff.kora.s3.client.telemetry.S3ClientTelemetry;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;

@ApiStatus.Experimental
public final class AwsS3ClientTelemetryInterceptor
implements ExecutionInterceptor {
    private static final ExecutionAttribute<S3ClientTelemetry.S3ClientTelemetryContext> CONTEXT = new ExecutionAttribute("kora-s3-telemetry-context");
    private static final ExecutionAttribute<Operation> OPERATION = new ExecutionAttribute("kora-s3-telemetry-operation");
    private final S3ClientTelemetry telemetry;
    private final AwsS3ClientConfig.AddressStyle addressStyle;

    public AwsS3ClientTelemetryInterceptor(S3ClientTelemetry telemetry, AwsS3ClientConfig.AddressStyle addressStyle) {
        this.telemetry = telemetry;
        this.addressStyle = addressStyle;
    }

    public void beforeExecution(Context.BeforeExecution execContext, ExecutionAttributes executionAttributes) {
        S3ClientTelemetry.S3ClientTelemetryContext telemetryContext = this.telemetry.get();
        executionAttributes.putAttribute(CONTEXT, (Object)telemetryContext);
    }

    public void afterMarshalling(Context.AfterMarshalling execContext, ExecutionAttributes executionAttributes) {
        S3ClientTelemetry.S3ClientTelemetryContext telemetryContext = (S3ClientTelemetry.S3ClientTelemetryContext)executionAttributes.getAttribute(CONTEXT);
        if (telemetryContext != null) {
            SdkHttpRequest request = execContext.httpRequest();
            Long contentLength = execContext.requestBody().flatMap(RequestBody::optionalContentLength).or(() -> execContext.asyncRequestBody().flatMap(AsyncRequestBody::contentLength)).orElse(null);
            BucketAndKey bk = this.addressStyle == AwsS3ClientConfig.AddressStyle.PATH ? AwsS3ClientTelemetryInterceptor.getPathAddress(request.encodedPath()) : AwsS3ClientTelemetryInterceptor.getVirtualHost(request.host(), request.encodedPath());
            telemetryContext.prepared(request.method().name(), bk.bucket(), bk.key(), contentLength);
            executionAttributes.putAttribute(OPERATION, (Object)new Operation(request.method().name().toUpperCase(), bk.bucket(), bk.key()));
        }
    }

    private static BucketAndKey getPathAddress(String path) {
        String key;
        String bucket;
        int startFrom;
        int n = startFrom = path.charAt(0) == '/' ? 1 : 0;
        if (path.equals("/")) {
            bucket = "/";
            key = null;
        } else {
            int bucketSeparator = path.indexOf(47, startFrom);
            if (bucketSeparator == -1) {
                bucket = path.substring(startFrom);
                key = null;
            } else {
                bucket = path.substring(startFrom, bucketSeparator);
                key = path.substring(bucketSeparator + 1);
            }
        }
        return new BucketAndKey(bucket, key);
    }

    private static BucketAndKey getVirtualHost(String host, String path) {
        int bucketEnd = host.indexOf(46);
        if (bucketEnd == -1) {
            return AwsS3ClientTelemetryInterceptor.getPathAddress(path);
        }
        int startFrom = path.charAt(0) == '/' ? 1 : 0;
        String bucket = host.substring(0, bucketEnd);
        String key = path.length() == 1 ? null : path.substring(startFrom);
        return new BucketAndKey(bucket, key);
    }

    public void afterExecution(Context.AfterExecution execContext, ExecutionAttributes executionAttributes) {
        S3ClientTelemetry.S3ClientTelemetryContext telemetryContext = (S3ClientTelemetry.S3ClientTelemetryContext)executionAttributes.getAttribute(CONTEXT);
        if (telemetryContext != null) {
            SdkHttpResponse httpResponse = execContext.response().sdkHttpResponse();
            Operation op = (Operation)executionAttributes.getAttribute(OPERATION);
            telemetryContext.close(op.method(), op.bucket(), op.key(), httpResponse.statusCode());
        }
    }

    public void onExecutionFailure(Context.FailedExecution execContext, ExecutionAttributes executionAttributes) {
        S3ClientTelemetry.S3ClientTelemetryContext telemetryContext = (S3ClientTelemetry.S3ClientTelemetryContext)executionAttributes.getAttribute(CONTEXT);
        if (telemetryContext != null) {
            String errorMessage;
            String errorCode;
            Integer statusCode = execContext.response().map(SdkResponse::sdkHttpResponse).map(SdkHttpResponse::statusCode).or(() -> execContext.httpResponse().map(SdkHttpResponse::statusCode)).orElse(-1);
            Throwable throwable = execContext.exception();
            if (throwable instanceof AwsServiceException) {
                AwsServiceException ae = (AwsServiceException)throwable;
                errorCode = ae.awsErrorDetails().errorCode();
                errorMessage = ae.awsErrorDetails().errorMessage();
            } else {
                errorCode = execContext.exception().getClass().getSimpleName();
                errorMessage = execContext.exception().getMessage();
            }
            Operation op = (Operation)executionAttributes.getAttribute(OPERATION);
            S3Exception s3Exception = new S3Exception(execContext.exception(), errorCode, errorMessage);
            telemetryContext.close(op.method(), op.bucket(), op.key(), statusCode.intValue(), s3Exception);
        }
    }

    private record BucketAndKey(String bucket, @Nullable String key) {
    }

    record Operation(String method, String bucket, String key) {
    }
}

