/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.s3.client.aws;

import java.io.InputStream;
import java.time.Instant;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import reactor.adapter.JdkFlowAdapter;
import ru.tinkoff.kora.s3.client.aws.AwsS3BodyAsync;
import ru.tinkoff.kora.s3.client.aws.AwsS3BodySync;
import ru.tinkoff.kora.s3.client.aws.AwsS3ObjectMeta;
import ru.tinkoff.kora.s3.client.model.S3Body;
import ru.tinkoff.kora.s3.client.model.S3Object;
import ru.tinkoff.kora.s3.client.model.S3ObjectMeta;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.async.ResponsePublisher;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

@ApiStatus.Experimental
@ApiStatus.Internal
public final class AwsS3Object
implements S3Object,
S3ObjectMeta {
    private final S3Body body;
    private final S3ObjectMeta meta;
    private final GetObjectResponse response;

    public AwsS3Object(String key, ResponseInputStream<GetObjectResponse> response) {
        GetObjectResponse res = (GetObjectResponse)response.response();
        long size = res.contentLength() == null ? -1L : res.contentLength();
        this.body = new AwsS3BodySync(res.contentEncoding(), res.contentType(), size, (InputStream)response);
        this.meta = new AwsS3ObjectMeta(key, res);
        this.response = res;
    }

    public AwsS3Object(String key, ResponsePublisher<GetObjectResponse> response) {
        GetObjectResponse res = (GetObjectResponse)response.response();
        long size = res.contentLength() == null ? -1L : res.contentLength();
        this.body = new AwsS3BodyAsync(res.contentEncoding(), res.contentType(), size, JdkFlowAdapter.publisherToFlowPublisher(response));
        this.meta = new AwsS3ObjectMeta(key, res);
        this.response = res;
    }

    public String key() {
        return this.meta.key();
    }

    public Instant modified() {
        return this.meta.modified();
    }

    public long size() {
        return this.meta.size();
    }

    public S3Body body() {
        return this.body;
    }

    public GetObjectResponse response() {
        return this.response;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AwsS3Object s3Object = (AwsS3Object)object;
        return Objects.equals(this.meta, s3Object.meta);
    }

    public int hashCode() {
        return Objects.hash(this.meta);
    }

    public String toString() {
        return this.body.toString();
    }
}

