/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.s3.client.aws;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.jetbrains.annotations.ApiStatus;
import org.reactivestreams.Publisher;
import reactor.adapter.JdkFlowAdapter;
import ru.tinkoff.kora.http.client.common.HttpClient;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequestBuilder;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.s3.client.aws.AwsS3ClientConfig;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

@ApiStatus.Experimental
public final class KoraAwsSdkHttpClient
implements SdkHttpClient,
SdkAsyncHttpClient {
    private final HttpClient httpClient;
    private final AwsS3ClientConfig clientConfig;

    public KoraAwsSdkHttpClient(HttpClient httpClient, AwsS3ClientConfig clientConfig) {
        this.httpClient = httpClient;
        this.clientConfig = clientConfig;
    }

    public String clientName() {
        return "Kora";
    }

    public ExecutableHttpRequest prepareRequest(final HttpExecuteRequest httpExecuteRequest) {
        return new ExecutableHttpRequest(){

            public HttpExecuteResponse call() {
                HttpClientRequest request = KoraAwsSdkHttpClient.this.asKoraRequest(httpExecuteRequest);
                HttpClientResponse response = (HttpClientResponse)KoraAwsSdkHttpClient.this.httpClient.execute(request).toCompletableFuture().join();
                return KoraAwsSdkHttpClient.asAwsResponse(response);
            }

            public void abort() {
            }
        };
    }

    public CompletableFuture<Void> execute(AsyncExecuteRequest asyncExecuteRequest) {
        HttpClientRequest request = this.asKoraRequest(asyncExecuteRequest);
        return this.httpClient.execute(request).thenAccept(response -> {
            SdkHttpFullResponse sdkHttpResponse = KoraAwsSdkHttpClient.asSdkResponse(response);
            asyncExecuteRequest.responseHandler().onHeaders((SdkHttpResponse)sdkHttpResponse);
            asyncExecuteRequest.responseHandler().onStream((Publisher)JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)response.body()));
        }).exceptionally(e -> {
            asyncExecuteRequest.responseHandler().onError(e);
            return null;
        }).toCompletableFuture();
    }

    private HttpClientRequest asKoraRequest(HttpExecuteRequest httpExecuteRequest) {
        SdkHttpRequest sdkHttpRequest = httpExecuteRequest.httpRequest();
        HttpClientRequestBuilder builder = KoraAwsSdkHttpClient.getBaseBuilder(sdkHttpRequest.getUri(), sdkHttpRequest.method().name(), sdkHttpRequest.rawQueryParameters(), sdkHttpRequest.headers());
        httpExecuteRequest.contentStreamProvider().ifPresent(provider -> {
            String contentType = sdkHttpRequest.firstMatchingHeader("Content-Type").orElse("application/octet-stream");
            String contentLength = sdkHttpRequest.firstMatchingHeader("Content-Length").orElse(null);
            if (contentLength == null) {
                builder.body(HttpBodyOutput.of((String)contentType, (InputStream)provider.newStream()));
            } else {
                builder.body(HttpBodyOutput.of((String)contentType, (long)Long.parseLong(contentLength), (InputStream)provider.newStream()));
            }
        });
        return builder.requestTimeout(this.clientConfig.requestTimeout()).build();
    }

    private HttpClientRequest asKoraRequest(AsyncExecuteRequest asyncExecuteRequest) {
        SdkHttpRequest sdkHttpRequest = asyncExecuteRequest.request();
        HttpClientRequestBuilder builder = KoraAwsSdkHttpClient.getBaseBuilder(sdkHttpRequest.getUri(), sdkHttpRequest.method().name(), sdkHttpRequest.rawQueryParameters(), sdkHttpRequest.headers());
        Flow.Publisher bodyFlow = JdkFlowAdapter.publisherToFlowPublisher((Publisher)asyncExecuteRequest.requestContentPublisher());
        String contentType = sdkHttpRequest.firstMatchingHeader("Content-Type").orElse("application/octet-stream");
        String contentLength = sdkHttpRequest.firstMatchingHeader("Content-Length").orElse(null);
        if (contentLength == null) {
            builder.body(HttpBodyOutput.of((String)contentType, (Flow.Publisher)bodyFlow));
        } else {
            builder.body(HttpBodyOutput.of((String)contentType, (long)Long.parseLong(contentLength), (Flow.Publisher)bodyFlow));
        }
        return builder.requestTimeout(this.clientConfig.requestTimeout()).build();
    }

    private static HttpClientRequestBuilder getBaseBuilder(URI sdkUri, String method, Map<String, List<String>> rawQueryParameters, Map<String, List<String>> headers) {
        try {
            URI uri = new URI(sdkUri.getScheme(), sdkUri.getAuthority(), sdkUri.getPath(), null, sdkUri.getFragment());
            HttpClientRequestBuilder builder = HttpClientRequest.of((String)method, (String)uri.toString());
            rawQueryParameters.forEach((k, v) -> {
                if (v == null || v.isEmpty() || v.get(0) == null) {
                    builder.queryParam(k);
                } else {
                    builder.queryParam(k, (Collection)v);
                }
            });
            headers.forEach((k, v) -> {
                if (!"host".equalsIgnoreCase((String)k) && !"expect".equalsIgnoreCase((String)k)) {
                    builder.header(k, v);
                }
            });
            return builder;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static HttpExecuteResponse asAwsResponse(HttpClientResponse koraHttpResponse) {
        SdkHttpFullResponse.Builder sdkResponseBuilder = SdkHttpResponse.builder();
        HashMap responseHeaders = new HashMap();
        koraHttpResponse.headers().forEach(e -> responseHeaders.put((String)e.getKey(), (List)e.getValue()));
        sdkResponseBuilder.headers(responseHeaders);
        sdkResponseBuilder.statusCode(koraHttpResponse.code());
        sdkResponseBuilder.statusText(String.valueOf(koraHttpResponse.code()));
        AbortableInputStream bodyStream = KoraAwsSdkHttpClient.asSdkResponseStream(koraHttpResponse);
        sdkResponseBuilder.content(bodyStream);
        SdkHttpFullResponse sdkHttpResponse = sdkResponseBuilder.build();
        return HttpExecuteResponse.builder().response((SdkHttpResponse)sdkHttpResponse).responseBody(bodyStream).build();
    }

    private static SdkHttpFullResponse asSdkResponse(HttpClientResponse koraHttpResponse) {
        SdkHttpFullResponse.Builder sdkResponseBuilder = SdkHttpResponse.builder();
        HashMap responseHeaders = new HashMap();
        koraHttpResponse.headers().forEach(e -> responseHeaders.put((String)e.getKey(), (List)e.getValue()));
        sdkResponseBuilder.headers(responseHeaders);
        sdkResponseBuilder.statusCode(koraHttpResponse.code());
        sdkResponseBuilder.statusText(String.valueOf(koraHttpResponse.code()));
        return sdkResponseBuilder.build();
    }

    private static AbortableInputStream asSdkResponseStream(HttpClientResponse koraHttpResponse) {
        HttpBodyInput body = koraHttpResponse.body();
        InputStream bodyIS = body.asInputStream();
        InputStream bodyAsInputStream = bodyIS != null ? bodyIS : new ByteArrayInputStream((byte[])body.asArrayStage().toCompletableFuture().join());
        return AbortableInputStream.create((InputStream)bodyAsInputStream, () -> {
            try {
                bodyAsInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public void close() {
    }
}

