/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.s3.client.aws;

import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.ApiStatus;
import ru.tinkoff.kora.application.graph.All;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.http.client.common.HttpClient;
import ru.tinkoff.kora.s3.client.S3ClientModule;
import ru.tinkoff.kora.s3.client.S3Config;
import ru.tinkoff.kora.s3.client.S3KoraAsyncClient;
import ru.tinkoff.kora.s3.client.S3KoraClient;
import ru.tinkoff.kora.s3.client.aws.AwsS3ClientConfig;
import ru.tinkoff.kora.s3.client.aws.AwsS3ClientTelemetryInterceptor;
import ru.tinkoff.kora.s3.client.aws.AwsS3KoraAsyncClient;
import ru.tinkoff.kora.s3.client.aws.AwsS3KoraClient;
import ru.tinkoff.kora.s3.client.aws.KoraAwsSdkHttpClient;
import ru.tinkoff.kora.s3.client.telemetry.S3ClientTelemetryFactory;
import ru.tinkoff.kora.s3.client.telemetry.S3KoraClientTelemetry;
import ru.tinkoff.kora.s3.client.telemetry.S3KoraClientTelemetryFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartS3AsyncClient;
import software.amazon.awssdk.services.s3.model.MultipartUpload;
import software.amazon.awssdk.services.s3.multipart.MultipartConfiguration;

@ApiStatus.Experimental
public interface AwsS3ClientModule
extends S3ClientModule {
    @Tag(value={AwsClient.class})
    @DefaultComponent
    default public HttpClient awsS3httpClient(HttpClient client) {
        return client;
    }

    @DefaultComponent
    default public KoraAwsSdkHttpClient awsKoraSdkHttpClient(@Tag(value={AwsClient.class}) HttpClient client, AwsS3ClientConfig clientConfig) {
        return new KoraAwsSdkHttpClient(client, clientConfig);
    }

    @Tag(value={AwsClient.class})
    @DefaultComponent
    default public ExecutorService awsAsyncExecutorService() {
        return Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2);
    }

    default public AwsS3ClientConfig awsS3ClientConfig(Config config, ConfigValueExtractor<AwsS3ClientConfig> extractor) {
        ConfigValue value = config.get("s3client.aws");
        return (AwsS3ClientConfig)extractor.extract(value);
    }

    @DefaultComponent
    default public AwsCredentialsProvider awsCredentialsProvider(S3Config s3Config) {
        return () -> AwsBasicCredentials.create((String)s3Config.accessKey(), (String)s3Config.secretKey());
    }

    @DefaultComponent
    default public S3Configuration awsS3Configuration(AwsS3ClientConfig awsS3ClientConfig) {
        return (S3Configuration)S3Configuration.builder().checksumValidationEnabled(Boolean.valueOf(awsS3ClientConfig.checksumValidationEnabled())).chunkedEncodingEnabled(Boolean.valueOf(awsS3ClientConfig.chunkedEncodingEnabled())).pathStyleAccessEnabled(Boolean.valueOf(awsS3ClientConfig.addressStyle() == AwsS3ClientConfig.AddressStyle.PATH)).build();
    }

    default public S3Client awsS3Client(SdkHttpClient httpClient, AwsCredentialsProvider credentialsProvider, S3Configuration s3Configuration, S3Config s3Config, AwsS3ClientConfig awsS3ClientConfig, S3ClientTelemetryFactory telemetryFactory, All<ExecutionInterceptor> interceptors) {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(credentialsProvider)).httpClient(httpClient)).endpointOverride(URI.create(s3Config.url()))).serviceConfiguration(s3Configuration)).region(Region.of((String)s3Config.region()))).overrideConfiguration(b -> b.addExecutionInterceptor((ExecutionInterceptor)new AwsS3ClientTelemetryInterceptor(telemetryFactory.get(s3Config.telemetry(), S3Client.class), awsS3ClientConfig.addressStyle())))).overrideConfiguration(b -> interceptors.forEach(arg_0 -> ((ClientOverrideConfiguration.Builder)b).addExecutionInterceptor(arg_0)))).build();
    }

    default public S3AsyncClient awsS3AsyncClient(SdkAsyncHttpClient asyncHttpClient, AwsCredentialsProvider credentialsProvider, S3Configuration s3Configuration, S3Config s3Config, AwsS3ClientConfig awsS3ClientConfig, S3ClientTelemetryFactory telemetryFactory, All<ExecutionInterceptor> interceptors) {
        return (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider(credentialsProvider)).httpClient(asyncHttpClient)).endpointOverride(URI.create(s3Config.url()))).serviceConfiguration(s3Configuration)).region(Region.of((String)s3Config.region()))).overrideConfiguration(b -> b.addExecutionInterceptor((ExecutionInterceptor)new AwsS3ClientTelemetryInterceptor(telemetryFactory.get(s3Config.telemetry(), S3AsyncClient.class), awsS3ClientConfig.addressStyle())))).overrideConfiguration(b -> interceptors.forEach(arg_0 -> ((ClientOverrideConfiguration.Builder)b).addExecutionInterceptor(arg_0)))).build();
    }

    default public S3KoraClient awsS3KoraClient(S3Client s3Client, S3KoraAsyncClient simpleAsyncClient, S3KoraClientTelemetryFactory telemetryFactory, S3Config config, AwsS3ClientConfig awsS3ClientConfig) {
        S3KoraClientTelemetry telemetry = telemetryFactory.get(config.telemetry(), S3KoraClient.class);
        return new AwsS3KoraClient(s3Client, simpleAsyncClient, telemetry, awsS3ClientConfig);
    }

    default public S3KoraAsyncClient awsS3KoraAsyncClient(S3AsyncClient s3AsyncClient, @Tag(value={AwsClient.class}) ExecutorService awsExecutor, S3KoraClientTelemetryFactory telemetryFactory, S3Config config, AwsS3ClientConfig awsS3ClientConfig) {
        S3KoraClientTelemetry telemetry = telemetryFactory.get(config.telemetry(), S3KoraAsyncClient.class);
        return new AwsS3KoraAsyncClient(s3AsyncClient, awsExecutor, telemetry, awsS3ClientConfig);
    }

    @Tag(value={MultipartUpload.class})
    default public MultipartS3AsyncClient multipartS3AsyncClient(S3AsyncClient asyncClient, AwsS3ClientConfig awsS3ClientConfig) {
        MultipartConfiguration config = (MultipartConfiguration)MultipartConfiguration.builder().thresholdInBytes(Long.valueOf(awsS3ClientConfig.upload().partSize().toBytes())).apiCallBufferSizeInBytes(Long.valueOf(awsS3ClientConfig.upload().bufferSize().toBytes())).minimumPartSizeInBytes(Long.valueOf(awsS3ClientConfig.upload().partSize().toBytes())).build();
        return MultipartS3AsyncClient.create((S3AsyncClient)asyncClient, (MultipartConfiguration)config);
    }
}

