/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.s3.client.aws;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.s3.client.S3DeleteException;
import ru.tinkoff.kora.s3.client.S3Exception;
import ru.tinkoff.kora.s3.client.S3KoraAsyncClient;
import ru.tinkoff.kora.s3.client.S3KoraClient;
import ru.tinkoff.kora.s3.client.S3NotFoundException;
import ru.tinkoff.kora.s3.client.aws.AwsS3ClientConfig;
import ru.tinkoff.kora.s3.client.aws.AwsS3Object;
import ru.tinkoff.kora.s3.client.aws.AwsS3ObjectList;
import ru.tinkoff.kora.s3.client.aws.AwsS3ObjectMeta;
import ru.tinkoff.kora.s3.client.aws.AwsS3ObjectMetaList;
import ru.tinkoff.kora.s3.client.aws.AwsS3ObjectUpload;
import ru.tinkoff.kora.s3.client.model.ByteS3Body;
import ru.tinkoff.kora.s3.client.model.PublisherS3Body;
import ru.tinkoff.kora.s3.client.model.S3Body;
import ru.tinkoff.kora.s3.client.model.S3Object;
import ru.tinkoff.kora.s3.client.model.S3ObjectList;
import ru.tinkoff.kora.s3.client.model.S3ObjectMeta;
import ru.tinkoff.kora.s3.client.model.S3ObjectMetaList;
import ru.tinkoff.kora.s3.client.model.S3ObjectUpload;
import ru.tinkoff.kora.s3.client.telemetry.S3KoraClientTelemetry;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

@ApiStatus.Experimental
public class AwsS3KoraClient
implements S3KoraClient {
    private final S3Client syncClient;
    private final S3KoraAsyncClient asyncClient;
    private final S3KoraClientTelemetry telemetry;
    private final AwsS3ClientConfig awsS3ClientConfig;

    public AwsS3KoraClient(S3Client syncClient, S3KoraAsyncClient asyncClient, S3KoraClientTelemetry telemetry, AwsS3ClientConfig awsS3ClientConfig) {
        this.syncClient = syncClient;
        this.telemetry = telemetry;
        this.awsS3ClientConfig = awsS3ClientConfig;
        this.asyncClient = asyncClient;
    }

    public S3Object get(String bucket, String key) throws S3NotFoundException {
        return AwsS3KoraClient.wrapWithTelemetry(() -> this.getInternal(bucket, key), () -> this.telemetry.get("GetObject", bucket, key, null));
    }

    private S3Object getInternal(String bucket, String key) throws S3NotFoundException {
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
        ResponseInputStream response = this.syncClient.getObject(request);
        return new AwsS3Object(request.key(), (ResponseInputStream<GetObjectResponse>)response);
    }

    public S3ObjectMeta getMeta(String bucket, String key) throws S3NotFoundException {
        return AwsS3KoraClient.wrapWithTelemetry(() -> this.getMetaInternal(bucket, key), () -> this.telemetry.get("GetObjectMeta", bucket, key, null));
    }

    private S3ObjectMeta getMetaInternal(String bucket, String key) throws S3NotFoundException {
        HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(key).build();
        HeadObjectResponse response = this.syncClient.headObject(request);
        return new AwsS3ObjectMeta(key, response);
    }

    public List<S3Object> get(String bucket, Collection<String> keys) {
        return AwsS3KoraClient.wrapWithTelemetry(() -> {
            ArrayList<S3Object> objects = new ArrayList<S3Object>(keys.size());
            for (String key : keys) {
                try {
                    S3Object object = this.getInternal(bucket, key);
                    objects.add(object);
                }
                catch (S3NotFoundException s3NotFoundException) {}
            }
            return objects;
        }, () -> this.telemetry.get("GetObjects", bucket, null, null));
    }

    public List<S3ObjectMeta> getMeta(String bucket, Collection<String> keys) {
        return AwsS3KoraClient.wrapWithTelemetry(() -> {
            ArrayList<S3ObjectMeta> metas = new ArrayList<S3ObjectMeta>(keys.size());
            for (String key : keys) {
                try {
                    S3ObjectMeta meta = this.getMeta(bucket, key);
                    metas.add(meta);
                }
                catch (S3NotFoundException s3NotFoundException) {}
            }
            return metas;
        }, () -> this.telemetry.get("GetObjectMetas", bucket, null, null));
    }

    public S3ObjectList list(String bucket, @Nullable String prefix, @Nullable String delimiter, int limit) {
        return AwsS3KoraClient.wrapWithTelemetry(() -> this.listInternal(bucket, prefix, delimiter, limit), () -> this.telemetry.get("ListObjects", bucket, prefix, null));
    }

    private S3ObjectList listInternal(String bucket, @Nullable String prefix, @Nullable String delimiter, int limit) {
        S3ObjectMetaList metaList = this.listMetaInternal(bucket, prefix, delimiter, limit);
        ArrayList<S3Object> objects = new ArrayList<S3Object>(metaList.metas().size());
        for (S3ObjectMeta meta : metaList.metas()) {
            S3Object object = this.getInternal(bucket, meta.key());
            objects.add(object);
        }
        return new AwsS3ObjectList(((AwsS3ObjectMetaList)metaList).response(), objects);
    }

    public S3ObjectMetaList listMeta(String bucket, @Nullable String prefix, @Nullable String delimiter, int limit) {
        return AwsS3KoraClient.wrapWithTelemetry(() -> this.listMetaInternal(bucket, prefix, delimiter, limit), () -> this.telemetry.get("ListObjectMetas", bucket, prefix, null));
    }

    private S3ObjectMetaList listMetaInternal(String bucket, @Nullable String prefix, @Nullable String delimiter, int limit) {
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucket).maxKeys(Integer.valueOf(limit)).prefix(prefix).delimiter(delimiter).build();
        ListObjectsV2Response response = this.syncClient.listObjectsV2(request);
        return new AwsS3ObjectMetaList(response);
    }

    public List<S3ObjectList> list(String bucket, Collection<String> prefixes, @Nullable String delimiter, int limitPerPrefix) {
        return AwsS3KoraClient.wrapWithTelemetry(() -> {
            ArrayList<S3ObjectList> lists = new ArrayList<S3ObjectList>(prefixes.size());
            for (String prefix : prefixes) {
                S3ObjectList list = this.listInternal(bucket, prefix, delimiter, limitPerPrefix);
                lists.add(list);
            }
            return lists;
        }, () -> this.telemetry.get("ListMultiObjects", bucket, null, null));
    }

    public List<S3ObjectMetaList> listMeta(String bucket, Collection<String> prefixes, @Nullable String delimiter, int limitPerPrefix) {
        return AwsS3KoraClient.wrapWithTelemetry(() -> {
            ArrayList<S3ObjectMetaList> lists = new ArrayList<S3ObjectMetaList>(prefixes.size());
            for (String prefix : prefixes) {
                S3ObjectMetaList list = this.listMeta(bucket, prefix, delimiter, limitPerPrefix);
                lists.add(list);
            }
            return lists;
        }, () -> this.telemetry.get("ListMultiObjectMetas", bucket, null, null));
    }

    public S3ObjectUpload put(String bucket, String key, S3Body body) {
        if (body instanceof PublisherS3Body || body.size() < 0L || body.size() > this.awsS3ClientConfig.upload().partSize().toBytes()) {
            try {
                return (S3ObjectUpload)this.asyncClient.put(bucket, key, body).toCompletableFuture().join();
            }
            catch (Exception e) {
                throw AwsS3KoraClient.handleException(e);
            }
        }
        PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().bucket(bucket).key(key).contentType(body.type()).contentEncoding(body.encoding());
        if (body.size() > 0L) {
            requestBuilder.contentLength(Long.valueOf(body.size()));
        }
        PutObjectRequest request = (PutObjectRequest)requestBuilder.build();
        Context ctx = Context.current();
        try {
            S3KoraClientTelemetry.S3KoraClientTelemetryContext context;
            block11: {
                Context fork = ctx.fork();
                fork.inject();
                context = this.telemetry.get("PutObject", bucket, key, body.size() > 0L ? Long.valueOf(body.size()) : null);
                try {
                    if (!(body instanceof ByteS3Body)) break block11;
                    ByteS3Body bb = (ByteS3Body)body;
                    PutObjectResponse response = this.syncClient.putObject(request, RequestBody.fromBytes((byte[])bb.bytes()));
                    context.close();
                    AwsS3ObjectUpload awsS3ObjectUpload = new AwsS3ObjectUpload(response);
                    return awsS3ObjectUpload;
                }
                catch (Exception e) {
                    S3Exception ex = AwsS3KoraClient.handleException(e);
                    context.close(ex);
                    throw ex;
                }
            }
            PutObjectResponse response = this.syncClient.putObject(request, RequestBody.fromContentProvider(() -> ((S3Body)body).asInputStream(), (long)body.size(), (String)body.type()));
            context.close();
            AwsS3ObjectUpload awsS3ObjectUpload = new AwsS3ObjectUpload(response);
            return awsS3ObjectUpload;
        }
        finally {
            ctx.inject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String bucket, String key) {
        DeleteObjectRequest request = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucket).key(key).build();
        Context ctx = Context.current();
        try {
            Context fork = ctx.fork();
            fork.inject();
            S3KoraClientTelemetry.S3KoraClientTelemetryContext context = this.telemetry.get("DeleteObject", bucket, key, null);
            try {
                this.syncClient.deleteObject(request);
                context.close();
            }
            catch (Exception e) {
                S3Exception ex = AwsS3KoraClient.handleException(e);
                context.close(ex);
                throw ex;
            }
        }
        finally {
            ctx.inject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String bucket, Collection<String> keys) {
        DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete((Delete)Delete.builder().objects(keys.stream().map(k -> (ObjectIdentifier)ObjectIdentifier.builder().key(k).build()).toList()).build()).build();
        Context ctx = Context.current();
        try {
            Context fork = ctx.fork();
            fork.inject();
            S3KoraClientTelemetry.S3KoraClientTelemetryContext context = this.telemetry.get("DeleteObjects", bucket, null, null);
            try {
                DeleteObjectsResponse response = this.syncClient.deleteObjects(request);
                if (response.hasErrors()) {
                    List<S3DeleteException.Error> errors = response.errors().stream().map(e -> new S3DeleteException.Error(e.key(), bucket, e.code(), e.message())).toList();
                    throw new S3DeleteException(errors);
                }
                context.close();
            }
            catch (Exception e2) {
                S3Exception ex = AwsS3KoraClient.handleException(e2);
                context.close(ex);
                throw ex;
            }
        }
        finally {
            ctx.inject();
        }
    }

    private static <T> T wrapWithTelemetry(Supplier<T> operationSupplier, Supplier<S3KoraClientTelemetry.S3KoraClientTelemetryContext> contextSupplier) {
        Context ctx = Context.current();
        try {
            T t;
            Context fork = ctx.fork();
            fork.inject();
            S3KoraClientTelemetry.S3KoraClientTelemetryContext context = contextSupplier.get();
            try {
                T value = operationSupplier.get();
                context.close();
                t = value;
            }
            catch (Exception e) {
                S3Exception ex = AwsS3KoraClient.handleException(e);
                context.close(ex);
                throw ex;
            }
            return t;
        }
        finally {
            ctx.inject();
        }
    }

    private static S3Exception handleException(Throwable e) {
        if (e instanceof CompletionException) {
            CompletionException ce = (CompletionException)e;
            e = ce.getCause();
        }
        if (e instanceof S3Exception) {
            S3Exception se = (S3Exception)e;
            return se;
        }
        if (e instanceof NoSuchKeyException) {
            NoSuchKeyException ke = (NoSuchKeyException)e;
            return S3NotFoundException.ofNoSuchKey((Throwable)e, (String)ke.awsErrorDetails().errorMessage());
        }
        if (e instanceof NoSuchBucketException) {
            NoSuchBucketException be = (NoSuchBucketException)e;
            return S3NotFoundException.ofNoSuchBucket((Throwable)e, (String)be.awsErrorDetails().errorMessage());
        }
        if (e instanceof AwsServiceException) {
            AwsServiceException ae = (AwsServiceException)e;
            return new S3Exception(e, ae.awsErrorDetails().errorCode(), ae.awsErrorDetails().errorMessage());
        }
        return new S3Exception(e, e.getClass().getSimpleName(), e.getMessage());
    }
}

