/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.grpc.client;

import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ServiceDescriptor;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import ru.tinkoff.grpc.client.GrpcClientChannelFactory;
import ru.tinkoff.grpc.client.config.GrpcClientConfig;
import ru.tinkoff.grpc.client.config.GrpcClientConfigInterceptor;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetry;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetryFactory;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetryInterceptor;
import ru.tinkoff.kora.application.graph.All;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;

public final class ManagedChannelLifecycle
implements Lifecycle,
Wrapped<ManagedChannel> {
    private final GrpcClientConfig config;
    private final ServiceDescriptor serviceDefinition;
    private final GrpcClientChannelFactory channelFactory;
    private final ChannelCredentials channelCredentials;
    private final GrpcClientTelemetryFactory telemetryFactory;
    private final All<ClientInterceptor> interceptors;
    private volatile ManagedChannel channel;

    public ManagedChannelLifecycle(GrpcClientConfig config, @Nullable ChannelCredentials channelCredentials, All<ClientInterceptor> interceptors, GrpcClientTelemetryFactory telemetryFactory, GrpcClientChannelFactory channelFactory, ServiceDescriptor serviceDefinition) {
        this.config = config;
        this.serviceDefinition = serviceDefinition;
        this.channelCredentials = channelCredentials;
        this.channelFactory = channelFactory;
        this.telemetryFactory = telemetryFactory;
        this.interceptors = interceptors;
    }

    public void init() {
        ManagedChannelBuilder<?> b;
        URI uri = URI.create(this.config.url());
        String host = uri.getHost();
        int port = uri.getPort();
        String scheme = uri.getScheme();
        if (port < 0) {
            if (Objects.equals(scheme, "http")) {
                port = 80;
            } else if (Objects.equals(scheme, "https")) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Unknown scheme '" + scheme + "'");
            }
        }
        ManagedChannelBuilder<?> managedChannelBuilder = b = this.channelCredentials == null ? this.channelFactory.forAddress(host, port) : this.channelFactory.forAddress(host, port, this.channelCredentials);
        if (Objects.equals(scheme, "http")) {
            b.usePlaintext();
        }
        ArrayList<Object> interceptors = new ArrayList<Object>(2);
        interceptors.add(new GrpcClientConfigInterceptor(this.config));
        GrpcClientTelemetry telemetry = this.telemetryFactory.get(this.serviceDefinition, this.config.telemetry(), uri);
        if (telemetry != null) {
            interceptors.add(new GrpcClientTelemetryInterceptor(telemetry));
        }
        interceptors.addAll((Collection<Object>)this.interceptors);
        b.intercept(interceptors);
        this.channel = b.build();
    }

    public void release() {
        ManagedChannel channel = this.channel;
        this.channel = null;
        if (channel != null) {
            channel.shutdown();
        }
    }

    public ManagedChannel value() {
        return this.channel;
    }
}

