/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.grpc.client.telemetry;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import jakarta.annotation.Nullable;
import java.net.URI;
import ru.tinkoff.grpc.client.telemetry.GrpcClientLogger;
import ru.tinkoff.grpc.client.telemetry.GrpcClientLoggerFactory;
import ru.tinkoff.grpc.client.telemetry.GrpcClientMetrics;
import ru.tinkoff.grpc.client.telemetry.GrpcClientMetricsFactory;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetry;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetryFactory;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTracer;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTracerFactory;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class DefaultGrpcClientTelemetryFactory
implements GrpcClientTelemetryFactory {
    @Nullable
    private final GrpcClientMetricsFactory metrics;
    @Nullable
    private final GrpcClientTracerFactory tracer;
    @Nullable
    private final GrpcClientLoggerFactory logger;

    public DefaultGrpcClientTelemetryFactory(@Nullable GrpcClientMetricsFactory metrics, @Nullable GrpcClientTracerFactory tracer, @Nullable GrpcClientLoggerFactory logger) {
        this.metrics = metrics;
        this.tracer = tracer;
        this.logger = logger;
    }

    @Override
    public GrpcClientTelemetry get(ServiceDescriptor service, TelemetryConfig telemetryConfig, URI uri) {
        GrpcClientLogger logger;
        GrpcClientMetrics metrics = this.metrics == null ? null : this.metrics.get(service, telemetryConfig.metrics(), uri);
        GrpcClientTracer tracer = this.tracer == null ? null : this.tracer.get(service, telemetryConfig.tracing(), uri);
        GrpcClientLogger grpcClientLogger = logger = this.logger == null ? null : this.logger.get(service, telemetryConfig.logging(), uri);
        if (!(metrics != null || tracer != null || logger != null && logger.enabled())) {
            return null;
        }
        return new DefaultGrpcClientTelemetry(metrics, tracer, logger, service, uri);
    }

    private static final class DefaultGrpcClientTelemetry
    implements GrpcClientTelemetry {
        @Nullable
        private final GrpcClientMetrics metrics;
        @Nullable
        private final GrpcClientTracer tracer;
        @Nullable
        private final GrpcClientLogger logger;
        private final ServiceDescriptor service;
        private final URI uri;

        public DefaultGrpcClientTelemetry(@Nullable GrpcClientMetrics metrics, @Nullable GrpcClientTracer tracer, @Nullable GrpcClientLogger logger, ServiceDescriptor service, URI uri) {
            this.metrics = metrics;
            this.tracer = tracer;
            this.logger = logger;
            this.service = service;
            this.uri = uri;
        }

        @Override
        public <ReqT, RespT> GrpcClientTelemetry.GrpcClientTelemetryCtx<ReqT, RespT> get(Context ctx, MethodDescriptor<ReqT, RespT> method, ClientCall<ReqT, RespT> call, Metadata headers) {
            GrpcClientTracer.GrpcClientSpan span;
            long startTime = System.nanoTime();
            GrpcClientTracer.GrpcClientSpan grpcClientSpan = span = this.tracer == null ? null : this.tracer.callSpan(ctx, method, this.uri, call, headers);
            if (this.logger != null && this.logger.enabled()) {
                this.logger.logCall(ctx, method, this.uri);
            }
            return new DefaultGrpcClientTelemetryCtx<ReqT, RespT>(ctx, startTime, method, this.metrics, this.logger, span);
        }
    }

    private static final class DefaultGrpcClientReceiveMessageTelemetryCtx<ReqT, RespT>
    implements GrpcClientTelemetry.GrpcClientReceiveMessageTelemetryCtx<ReqT, RespT> {
        private final GrpcClientTracer.GrpcClientResponseSpan span;

        public DefaultGrpcClientReceiveMessageTelemetryCtx(GrpcClientTracer.GrpcClientResponseSpan span) {
            this.span = span;
        }

        @Override
        public void close(Exception e) {
            if (this.span != null) {
                this.span.close(e);
            }
        }

        @Override
        public void close() {
            if (this.span != null) {
                this.span.close();
            }
        }
    }

    private static final class DefaultGrpcClientSendMessageTelemetryCtx<ReqT, RespT>
    implements GrpcClientTelemetry.GrpcClientSendMessageTelemetryCtx<ReqT, RespT> {
        @Nullable
        private final GrpcClientTracer.GrpcClientRequestSpan span;

        public DefaultGrpcClientSendMessageTelemetryCtx(@Nullable GrpcClientTracer.GrpcClientRequestSpan span) {
            this.span = span;
        }

        @Override
        public void close(Exception e) {
            if (this.span != null) {
                this.span.close(e);
            }
        }

        @Override
        public void close() {
            if (this.span != null) {
                this.span.close();
            }
        }
    }

    private static final class DefaultGrpcClientTelemetryCtx<ReqT, RespT>
    implements GrpcClientTelemetry.GrpcClientTelemetryCtx<ReqT, RespT> {
        private final long startTime;
        private final MethodDescriptor<ReqT, RespT> method;
        @Nullable
        private final GrpcClientMetrics metrics;
        @Nullable
        private final GrpcClientLogger logger;
        @Nullable
        private final GrpcClientTracer.GrpcClientSpan span;
        private final Context ctx;

        public DefaultGrpcClientTelemetryCtx(Context ctx, long startTime, MethodDescriptor<ReqT, RespT> method, GrpcClientMetrics metrics, GrpcClientLogger logger, GrpcClientTracer.GrpcClientSpan span) {
            this.ctx = ctx;
            this.startTime = startTime;
            this.method = method;
            this.metrics = metrics;
            this.logger = logger;
            this.span = span;
        }

        @Override
        public void close(Status status, Metadata trailers) {
            if (this.logger != null) {
                this.logger.logEnd(this.method, this.startTime, status, trailers);
            }
            if (this.span != null) {
                this.span.close(status, trailers);
            }
            if (this.metrics != null) {
                this.metrics.recordEnd(this.method, this.startTime, status, trailers);
            }
        }

        @Override
        public void close(Exception e) {
            if (this.logger != null) {
                this.logger.logEnd(this.method, this.startTime, e);
            }
            if (this.span != null) {
                this.span.close(e);
            }
            if (this.metrics != null) {
                this.metrics.recordEnd(this.method, this.startTime, e);
            }
        }

        @Override
        public GrpcClientTelemetry.GrpcClientSendMessageTelemetryCtx<ReqT, RespT> sendMessage(ReqT message) {
            GrpcClientTracer.GrpcClientRequestSpan span;
            GrpcClientTracer.GrpcClientRequestSpan grpcClientRequestSpan = span = this.span == null ? null : this.span.reqSpan(this.ctx, this.method, message);
            if (this.logger != null) {
                this.logger.logSendMessage(this.method, message);
            }
            if (this.metrics != null) {
                this.metrics.recordSendMessage(this.method, message);
            }
            return new DefaultGrpcClientSendMessageTelemetryCtx(span);
        }

        @Override
        public GrpcClientTelemetry.GrpcClientReceiveMessageTelemetryCtx<ReqT, RespT> receiveMessage(RespT message) {
            GrpcClientTracer.GrpcClientResponseSpan span;
            GrpcClientTracer.GrpcClientResponseSpan grpcClientResponseSpan = span = this.span == null ? null : this.span.resSpan(this.ctx, this.method, message);
            if (this.logger != null) {
                this.logger.logReceiveMessage(this.method, message);
            }
            if (this.metrics != null) {
                this.metrics.recordReceiveMessage(this.method, message);
            }
            return new DefaultGrpcClientReceiveMessageTelemetryCtx(span);
        }
    }
}

