/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.grpc.client;

import io.grpc.ChannelCredentials;
import io.grpc.ManagedChannelBuilder;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;

public interface GrpcClientChannelFactory {
    default public ManagedChannelBuilder<?> forAddress(String host, int port) {
        return this.forTarget(GrpcClientChannelFactory.authorityFromHostAndPort(host, port));
    }

    default public ManagedChannelBuilder<?> forAddress(String host, int port, ChannelCredentials creds) {
        return this.forTarget(GrpcClientChannelFactory.authorityFromHostAndPort(host, port), creds);
    }

    public ManagedChannelBuilder<?> forAddress(SocketAddress var1);

    public ManagedChannelBuilder<?> forAddress(SocketAddress var1, ChannelCredentials var2);

    public ManagedChannelBuilder<?> forTarget(String var1);

    public ManagedChannelBuilder<?> forTarget(String var1, ChannelCredentials var2);

    private static String authorityFromHostAndPort(String host, int port) {
        try {
            return new URI(null, null, host, port, null, null, null).getAuthority();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host or port: " + host + " " + port, ex);
        }
    }
}

