/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.grpc.client;

import io.grpc.ChannelCredentials;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.EventLoopGroup;
import java.net.SocketAddress;
import ru.tinkoff.grpc.client.GrpcClientChannelFactory;
import ru.tinkoff.kora.netty.common.NettyChannelFactory;

public final class GrpcNettyClientChannelFactory
implements GrpcClientChannelFactory {
    private final EventLoopGroup eventLoopGroup;
    private final NettyChannelFactory nettyChannelFactory;

    public GrpcNettyClientChannelFactory(EventLoopGroup eventLoopGroup, NettyChannelFactory nettyChannelFactory) {
        this.eventLoopGroup = eventLoopGroup;
        this.nettyChannelFactory = nettyChannelFactory;
    }

    @Override
    public ManagedChannelBuilder<?> forAddress(SocketAddress serverAddress) {
        return NettyChannelBuilder.forAddress((SocketAddress)serverAddress).channelFactory(this.nettyChannelFactory.getClientFactory()).eventLoopGroup(this.eventLoopGroup);
    }

    @Override
    public ManagedChannelBuilder<?> forAddress(SocketAddress serverAddress, ChannelCredentials creds) {
        return NettyChannelBuilder.forAddress((SocketAddress)serverAddress, (ChannelCredentials)creds).channelFactory(this.nettyChannelFactory.getClientFactory()).eventLoopGroup(this.eventLoopGroup);
    }

    @Override
    public ManagedChannelBuilder<?> forTarget(String target) {
        return NettyChannelBuilder.forTarget((String)target).channelFactory(this.nettyChannelFactory.getClientFactory()).eventLoopGroup(this.eventLoopGroup);
    }

    @Override
    public ManagedChannelBuilder<?> forTarget(String target, ChannelCredentials creds) {
        return NettyChannelBuilder.forTarget((String)target, (ChannelCredentials)creds).channelFactory(this.nettyChannelFactory.getClientFactory()).eventLoopGroup(this.eventLoopGroup);
    }
}

