/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.grpc.client.config;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ru.tinkoff.grpc.client.config.DefaultServiceConfig;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public final class DefaultServiceConfigConfigValueExtractor
implements ConfigValueExtractor<DefaultServiceConfig> {
    @Nullable
    public DefaultServiceConfig extract(ConfigValue<?> value) {
        if (value.isNull()) {
            return null;
        }
        ConfigValue.ObjectValue object = value.asObject();
        Map<String, Object> map = this.toMap(object);
        return new DefaultServiceConfig(map);
    }

    private Map<String, Object> toMap(ConfigValue.ObjectValue objectValue) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : objectValue) {
            String key = (String)entry.getKey();
            ConfigValue value = (ConfigValue)entry.getValue();
            Object object = this.toObject(value);
            if (object == null) continue;
            result.put(key, object);
        }
        return result;
    }

    private Object toObject(ConfigValue<?> value) {
        if (value instanceof ConfigValue.StringValue) {
            ConfigValue.StringValue str = (ConfigValue.StringValue)value;
            return str.value();
        }
        if (value instanceof ConfigValue.BooleanValue) {
            ConfigValue.BooleanValue bool = (ConfigValue.BooleanValue)value;
            return bool.value();
        }
        if (value instanceof ConfigValue.NumberValue) {
            ConfigValue.NumberValue num = (ConfigValue.NumberValue)value;
            return num.value().doubleValue();
        }
        if (value instanceof ConfigValue.ObjectValue) {
            ConfigValue.ObjectValue obj = (ConfigValue.ObjectValue)value;
            return this.toMap(obj);
        }
        if (value instanceof ConfigValue.ArrayValue) {
            ConfigValue.ArrayValue arr = (ConfigValue.ArrayValue)value;
            ArrayList<Object> list = new ArrayList<Object>();
            for (ConfigValue item : arr) {
                Object object = this.toObject(item);
                if (object == null) continue;
                list.add(object);
            }
            return list;
        }
        if (value instanceof ConfigValue.NullValue) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported config value type: " + String.valueOf(value.getClass()));
    }
}

