/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.grpc.client.telemetry;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.CancellationException;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetry;
import ru.tinkoff.kora.common.Context;

public final class GrpcClientTelemetryInterceptor
implements ClientInterceptor {
    private final GrpcClientTelemetry telemetry;

    public GrpcClientTelemetryInterceptor(GrpcClientTelemetry telemetry) {
        this.telemetry = telemetry;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall call = next.newCall(method, callOptions);
        return new MyClientCall<ReqT, RespT>(Context.current().fork(), method, call, this.telemetry);
    }

    private static final class MyClientCall<ReqT, RespT>
    extends ForwardingClientCall<ReqT, RespT> {
        private final Context ctx;
        private final MethodDescriptor<ReqT, RespT> method;
        private final ClientCall<ReqT, RespT> delegate;
        private final GrpcClientTelemetry telemetry;
        private volatile GrpcClientTelemetry.GrpcClientTelemetryCtx<ReqT, RespT> tctx;

        private MyClientCall(Context ctx, MethodDescriptor<ReqT, RespT> method, ClientCall<ReqT, RespT> delegate, GrpcClientTelemetry telemetry) {
            this.ctx = ctx;
            this.method = method;
            this.delegate = delegate;
            this.telemetry = telemetry;
        }

        protected ClientCall<ReqT, RespT> delegate() {
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            Context oldCtx = Context.current();
            this.ctx.inject();
            this.tctx = this.telemetry.get(this.ctx, this.method, this.delegate, headers);
            try {
                this.delegate.start(new MyListener<ReqT, RespT>(responseListener, this.ctx, this.tctx), headers);
            }
            finally {
                oldCtx.inject();
            }
        }

        public void sendMessage(ReqT message) {
            Context oldCtx = Context.current();
            this.ctx.inject();
            GrpcClientTelemetry.GrpcClientSendMessageTelemetryCtx<ReqT, RespT> tctx = this.tctx.sendMessage(message);
            try {
                super.sendMessage(message);
                tctx.close();
            }
            catch (Exception e) {
                tctx.close(e);
                throw e;
            }
            finally {
                oldCtx.inject();
            }
        }

        public void cancel(@Nullable String message, @Nullable Throwable cause) {
            Context oldCtx = Context.current();
            this.ctx.inject();
            try {
                super.cancel(message, cause);
                if (cause != null) {
                    if (cause instanceof Exception) {
                        Exception ex = (Exception)cause;
                        this.tctx.close(ex);
                    } else {
                        this.tctx.close(new RuntimeException(cause));
                    }
                } else if (message != null) {
                    this.tctx.close(new CancellationException(message));
                } else {
                    this.tctx.close(new CancellationException());
                }
            }
            catch (Exception e) {
                this.tctx.close(e);
                throw e;
            }
            finally {
                oldCtx.inject();
            }
        }
    }

    private static class MyListener<ReqT, RespT>
    extends ClientCall.Listener<RespT> {
        private final ClientCall.Listener<RespT> responseListener;
        private final GrpcClientTelemetry.GrpcClientTelemetryCtx<ReqT, RespT> telemetry;
        private final Context ctx;

        public MyListener(ClientCall.Listener<RespT> responseListener, Context ctx, GrpcClientTelemetry.GrpcClientTelemetryCtx<ReqT, RespT> telemetry) {
            this.responseListener = responseListener;
            this.telemetry = telemetry;
            this.ctx = ctx;
        }

        public void onMessage(RespT message) {
            Context oldCtx = Context.current();
            this.ctx.inject();
            GrpcClientTelemetry.GrpcClientReceiveMessageTelemetryCtx<ReqT, RespT> tctx = this.telemetry.receiveMessage(message);
            try {
                this.responseListener.onMessage(message);
                tctx.close();
            }
            catch (Exception e) {
                tctx.close(e);
                throw e;
            }
            finally {
                oldCtx.inject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(Status status, Metadata trailers) {
            Context oldCtx = Context.current();
            this.ctx.inject();
            try {
                this.responseListener.onClose(status, trailers);
            }
            finally {
                this.telemetry.close(status, trailers);
                oldCtx.inject();
            }
        }
    }
}

