/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.grpc.client.config;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;
import ru.tinkoff.grpc.client.config.GrpcClientConfig;

public final class GrpcClientConfigInterceptor
implements ClientInterceptor {
    private final GrpcClientConfig config;

    public GrpcClientConfigInterceptor(GrpcClientConfig config) {
        this.config = config;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (callOptions.getDeadline() == null && this.config.timeout() != null) {
            callOptions = callOptions.withDeadlineAfter(this.config.timeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        return next.newCall(method, callOptions);
    }
}

