/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.grpc.client;

import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ServiceDescriptor;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.grpc.client.GrpcClientBuilderConfigurer;
import ru.tinkoff.grpc.client.GrpcClientChannelFactory;
import ru.tinkoff.grpc.client.config.DefaultServiceConfig;
import ru.tinkoff.grpc.client.config.GrpcClientConfig;
import ru.tinkoff.grpc.client.config.GrpcClientConfigInterceptor;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetry;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetryFactory;
import ru.tinkoff.grpc.client.telemetry.GrpcClientTelemetryInterceptor;
import ru.tinkoff.kora.application.graph.All;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.util.TimeUtils;

public final class ManagedChannelLifecycle
implements Lifecycle,
Wrapped<ManagedChannel> {
    private static final Logger logger = LoggerFactory.getLogger(ManagedChannelLifecycle.class);
    private final GrpcClientConfig config;
    private final ServiceDescriptor serviceDefinition;
    private final GrpcClientChannelFactory channelFactory;
    private final ChannelCredentials channelCredentials;
    private final GrpcClientTelemetryFactory telemetryFactory;
    private final All<ClientInterceptor> interceptors;
    @Nullable
    private final GrpcClientBuilderConfigurer configurer;
    private volatile ManagedChannel channel;

    public ManagedChannelLifecycle(GrpcClientConfig config, @Nullable ChannelCredentials channelCredentials, All<ClientInterceptor> interceptors, @Nullable GrpcClientBuilderConfigurer configurer, GrpcClientTelemetryFactory telemetryFactory, GrpcClientChannelFactory channelFactory, ServiceDescriptor serviceDefinition) {
        this.config = config;
        this.serviceDefinition = serviceDefinition;
        this.channelCredentials = channelCredentials;
        this.channelFactory = channelFactory;
        this.telemetryFactory = telemetryFactory;
        this.interceptors = interceptors;
        this.configurer = configurer;
    }

    public void init() {
        DefaultServiceConfig defaultServiceConfig;
        ManagedChannelBuilder<?> builder;
        logger.debug("GrpcManagedChannel '{}' starting...", (Object)this.config.url());
        long started = System.nanoTime();
        URI uri = URI.create(this.config.url());
        String host = uri.getHost();
        int port = uri.getPort();
        String scheme = uri.getScheme();
        if (port < 0) {
            if (Objects.equals(scheme, "http")) {
                port = 80;
            } else if (Objects.equals(scheme, "https")) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Unknown scheme '" + scheme + "'");
            }
        }
        ManagedChannelBuilder<?> managedChannelBuilder = builder = this.channelCredentials == null ? this.channelFactory.forAddress(host, port) : this.channelFactory.forAddress(host, port, this.channelCredentials);
        if (Objects.equals(scheme, "http")) {
            builder.usePlaintext();
        }
        ArrayList<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>(2);
        interceptors.addAll((Collection<ClientInterceptor>)this.interceptors);
        GrpcClientTelemetry telemetry = this.telemetryFactory.get(this.serviceDefinition, this.config.telemetry(), uri);
        if (telemetry != null) {
            interceptors.add(new GrpcClientTelemetryInterceptor(telemetry));
        }
        interceptors.add(new GrpcClientConfigInterceptor(this.config));
        builder.intercept(interceptors);
        if (this.config.keepAliveTime() != null) {
            builder.keepAliveTime(this.config.keepAliveTime().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.config.keepAliveTimeout() != null) {
            builder.keepAliveTimeout(this.config.keepAliveTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.config.loadBalancingPolicy() != null) {
            builder.defaultLoadBalancingPolicy(this.config.loadBalancingPolicy());
        }
        if ((defaultServiceConfig = this.config.defaultServiceConfig()) != null && !defaultServiceConfig.content.isEmpty()) {
            builder.defaultServiceConfig(defaultServiceConfig.content);
        }
        if (this.configurer != null) {
            builder = this.configurer.configure(builder);
        }
        this.channel = builder.build();
        logger.info("GrpcManagedChannel '{}' started in {}", (Object)this.config.url(), (Object)TimeUtils.tookForLogging((long)started));
    }

    public void release() {
        ManagedChannel channel = this.channel;
        this.channel = null;
        if (channel != null) {
            logger.debug("GrpcManagedChannel '{}' stopping...", (Object)this.config.url());
            long started = System.nanoTime();
            channel.shutdown();
            logger.info("GrpcManagedChannel '{}' stopped in {}", (Object)this.config.url(), (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public ManagedChannel value() {
        return this.channel;
    }
}

