/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.grpc.telemetry;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import javax.annotation.Nullable;
import ru.tinkoff.kora.grpc.telemetry.DefaultGrpcServerTelemetryContext;
import ru.tinkoff.kora.grpc.telemetry.GrpcServerLogger;
import ru.tinkoff.kora.grpc.telemetry.GrpcServerMetrics;
import ru.tinkoff.kora.grpc.telemetry.GrpcServerMetricsFactory;
import ru.tinkoff.kora.grpc.telemetry.GrpcServerTelemetry;
import ru.tinkoff.kora.grpc.telemetry.GrpcServerTracer;

public final class DefaultGrpcServerTelemetry
implements GrpcServerTelemetry {
    @Nullable
    private final GrpcServerMetricsFactory metrics;
    @Nullable
    private final GrpcServerTracer tracing;
    @Nullable
    private final GrpcServerLogger logger;

    public DefaultGrpcServerTelemetry(@Nullable GrpcServerMetricsFactory metrics, @Nullable GrpcServerTracer tracing, @Nullable GrpcServerLogger logger) {
        this.metrics = metrics;
        this.tracing = tracing;
        this.logger = logger;
    }

    @Override
    public GrpcServerTelemetry.GrpcServerTelemetryContext createContext(ServerCall<?, ?> call, Metadata headers) {
        GrpcServerTracer.GrpcServerSpan span;
        long start = System.nanoTime();
        String serviceName = this.service(call);
        String methodName = this.method(call);
        GrpcServerMetrics metrics = this.metrics == null ? null : this.metrics.get(call, headers, serviceName, methodName);
        GrpcServerTracer.GrpcServerSpan grpcServerSpan = span = this.tracing == null ? null : this.tracing.createSpan(call, headers, serviceName, methodName);
        if (this.logger != null) {
            this.logger.logBegin(call, headers, serviceName, methodName);
        }
        return new DefaultGrpcServerTelemetryContext(start, serviceName, methodName, metrics, this.logger, span);
    }

    private String service(ServerCall<?, ?> call) {
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        int slashIndex = fullMethodName.lastIndexOf(47);
        if (slashIndex == -1) {
            return "unknownService";
        }
        return fullMethodName.substring(0, slashIndex);
    }

    private String method(ServerCall<?, ?> call) {
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        int slashIndex = fullMethodName.lastIndexOf(47);
        if (slashIndex == -1) {
            return "unknownMethod";
        }
        return fullMethodName.substring(slashIndex + 1);
    }
}

